/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.mixin;

import java.util.Objects;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.ToastsHandler;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ToastComponent.class}, priority=5000)
public class ToastComponentMixin {
    @Inject(at={@At(value="HEAD")}, method={"addToast"}, cancellable=true)
    private void onAddToast(Toast toast, CallbackInfo info) {
        ToastsHandler toastsHandler = new ToastsHandler(Managers.getConfigManager().getToastsFilteringData(), Objects.requireNonNull(Managers.getToastManager()), info);
        if (toast instanceof AdvancementToast) {
            AdvancementToast advancementToast = (AdvancementToast)toast;
            toastsHandler.handleAdvancementToasts(advancementToast);
        } else if (Services.FTB_QUESTS.isQuest(toast)) {
            toastsHandler.handleFTBQuestsToasts(toast);
        } else if (toast instanceof RecipeToast) {
            toastsHandler.handleRecipeToasts();
        } else if (toast instanceof SystemToast) {
            toastsHandler.handleSystemToasts();
        } else if (toast instanceof TutorialToast) {
            toastsHandler.handleTutorialToasts();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"clear"})
    private void onClear(CallbackInfo info) {
        Objects.requireNonNull(Managers.getToastManager()).clear();
    }
}

