/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import java.util.Random;
import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;

public class QuirkyAnimation
extends FancyToastAnimation {
    private final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private final Appearance ICON_SCALE = new Appearance(3500, 0);
    private final Appearance BANNER_APPEARANCE = new Appearance(900, 1200);
    private final Appearance BACKGROUND_APPEARANCE = new Appearance(1000, 1000);
    private final Appearance TEXT_APPEARANCE = new Appearance(1000, 1800);
    private final int FADE_OUT_DURATION = 1500;
    private final int DURATION = 6500;
    private float randomRotation;

    @Override
    public void setup(AnimationSetup setup, Minecraft minecraft, int toastWidth, int toastHeight) {
        super.setup(setup, minecraft, toastWidth, toastHeight);
        this.setLines(this.displayInfo.getAnnouncement(), this.displayInfo.getDescription());
        this.randomRotation = new Random().nextFloat(-0.4f, 0.4f);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, long time) {
        float y;
        super.draw(guiGraphics, time);
        float iconAppearProgress = this.ICON_APPEARANCE.getProgress(time);
        float iconScaleProgress = this.ICON_SCALE.getProgress(time);
        float bannerAppearProgress = this.BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = this.BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = this.TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 5000);
        GuiContext context = new GuiContext(guiGraphics);
        float globalSinX = this.sinusoidLoop(time, 1.0f, 7.0f);
        float globalSinY = this.sinusoidLoop(time, 2.0f, 5.0f);
        context.push();
        context.translate(globalSinX, globalSinY - 20.0f);
        if (fadeOutProgress > 0.0f) {
            float fadeOutScaleX = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            float fadeOutRotation = MathEasing.easeInLerp(0.0f, this.randomRotation, fadeOutProgress);
            int toastCenterX = this.toastWidth / 2;
            int toastCenterY = this.toastHeight / 2;
            context.push();
            context.scaleAround(fadeOutScaleX, toastCenterX, toastCenterY);
            context.rotateAround(fadeOutRotation, toastCenterX, toastCenterY);
        }
        if (bannerAppearProgress > 0.0f) {
            context.push();
            y = 58.0f;
            if (bannerAppearProgress != 1.0f) {
                y = MathEasing.easeOutLerp(-24.0f, 58.0f, bannerAppearProgress);
            }
            context.translate(0.0f, y);
            this.drawBanner(context);
            context.pop();
        }
        if (backgroundAppearProgress > 0.0f) {
            context.push();
            if (backgroundAppearProgress != 1.0f) {
                y = MathEasing.easeOutLerp(-95.0f, 0.0f, backgroundAppearProgress);
                context.translate(0.0f, y);
            }
            this.drawBackground(context);
            context.pop();
        }
        if (iconAppearProgress > 0.0f) {
            context.push();
            float posY = 55.0f;
            if (iconAppearProgress != 1.0f) {
                posY = MathEasing.easeOutLerp(-95.0f, 55.0f, iconAppearProgress);
            }
            if (iconScaleProgress > 0.0f && iconScaleProgress != 1.0f) {
                float scale = MathEasing.easeOutLerp(3.0f, 1.0f, iconScaleProgress);
                context.scaleAround(scale, 81.0f, 17.0f);
            }
            float sinY = this.sinusoidLoop(time, 2.0f, -1.2f);
            context.translate(0.0f, sinY + posY);
            this.drawIcon(context);
            context.pop();
        }
        if (textAppearProgress > 0.05f) {
            this.drawTitle(guiGraphics, textAppearProgress);
            this.drawDescription(guiGraphics, textAppearProgress);
        }
        if (fadeOutProgress > 0.0f) {
            context.pop();
        }
        context.pop();
    }

    @Override
    protected void drawDescription(GuiGraphics guiGraphics, float alpha) {
        List<FormattedCharSequence> descriptionLines = this.getDescriptionLines();
        if (descriptionLines.isEmpty()) {
            return;
        }
        int centerToastX = this.toastWidth / 2;
        int descriptionColor = Colors.alpha(alpha, this.displayInfo.getAdvancementType().getSecondaryColor());
        guiGraphics.drawCenteredString(this.minecraft.font, descriptionLines.get(0), centerToastX, 38, descriptionColor);
        if (descriptionLines.size() > 1) {
            FormattedCharSequence descriptionSecondLine = descriptionLines.get(1);
            if (descriptionLines.size() == 2) {
                guiGraphics.drawCenteredString(this.minecraft.font, descriptionSecondLine, centerToastX, 47, descriptionColor);
            } else {
                guiGraphics.drawCenteredString(this.minecraft.font, descriptionSecondLine, centerToastX - this.minecraft.font.width("...") / 2, 47, descriptionColor);
                guiGraphics.drawCenteredString(this.minecraft.font, "...", centerToastX + this.minecraft.font.width(descriptionSecondLine) / 2, 47, descriptionColor);
            }
        }
    }

    @Override
    public int getDuration() {
        return 6500;
    }

    @Override
    public int getToastSoundTiming() {
        return this.TEXT_APPEARANCE.startPoint() + 180;
    }
}

