/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.core.manager.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends AbstractSelectionList<Entry> {
    private final List<Entry> lines = new ArrayList<Entry>(10);
    private float scrollSpeed = 0.4f;

    public CreditsList(Minecraft minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, 18);
        this.setX(x);
        this.updateList(data);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.height / this.itemHeight + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.height / this.itemHeight; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    private void acceptLines() {
        for (Entry line : this.lines) {
            this.addEntry(line);
        }
    }

    private void addSpace() {
        this.lines.add(new SpaceEntry(this, ""));
    }

    private void addCategory(String category) {
        this.lines.add(new CategoryEntry(this, category));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        String content = user.name().compareTo("{user.name}") != 0 ? user.name() : this.minecraft.getUser().getName();
        this.lines.add(new UserEntry(this, content, user.annotation()));
    }

    public void scroll() {
        this.setScrollAmount(this.getScrollAmount() + (double)this.scrollSpeed);
        if (this.getScrollAmount() == (double)this.getMaxScroll()) {
            this.setScrollAmount(0.0);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.scrollSpeed = 1.2f;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.scrollSpeed = 0.4f;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    protected void renderListBackground(@NotNull GuiGraphics guiGraphics) {
    }

    protected void renderListSeparators(@NotNull GuiGraphics guiGraphics) {
    }

    protected boolean scrollbarVisible() {
        return false;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    protected static abstract class Entry
    extends AbstractSelectionList.Entry<Entry> {
        protected final CreditsList parentList;
        protected final String content;
        protected final Font font;

        public Entry(CreditsList parentList, String content) {
            this.parentList = parentList;
            this.content = content;
            this.font = ((CreditsList)this.parentList).minecraft.font;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        }
    }

    private static class SpaceEntry
    extends Entry {
        public SpaceEntry(CreditsList parentList, String content) {
            super(parentList, content);
        }
    }

    private static class CategoryEntry
    extends Entry {
        private final Component displayName;
        private final int xCenter;

        public CategoryEntry(CreditsList parentList, String content) {
            super(parentList, content);
            this.displayName = Components.of("label." + this.content);
            this.xCenter = parentList.getWidth() / 2;
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.drawCenteredString(this.font, this.displayName, this.xCenter, y, -256);
        }
    }

    private static class UserEntry
    extends Entry {
        private final String annotation;
        private final boolean isValidAnnotation;

        public UserEntry(CreditsList parentList, String content, String annotation) {
            super(parentList, content);
            this.annotation = annotation;
            this.isValidAnnotation = this.annotation != null && !this.annotation.isEmpty();
        }

        @Override
        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.drawString(this.font, this.content, x, y, -1);
            if (this.isValidAnnotation) {
                guiGraphics.drawString(this.font, this.annotation, x + this.font.width(this.content) + 8, y, -6250336);
            }
        }
    }
}

