/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import net.raphimc.immediatelyfast.ImmediatelyFast;

public class BufferAllocatorPool {
    private static final ReferenceList<Entry> FREE = new ReferenceArrayList();
    private static final ReferenceList<Entry> IN_USE = new ReferenceArrayList();
    private static final Reference2ObjectMap<ByteBufferBuilder, Entry> BUFFER_ALLOCATOR_MAPPING = new Reference2ObjectOpenHashMap();

    private BufferAllocatorPool() {
    }

    public static ByteBufferBuilder borrowBufferAllocator() {
        Entry entry;
        RenderSystem.assertOnRenderThread();
        if (FREE.isEmpty()) {
            entry = new Entry(new ByteBufferBuilder(256));
        } else {
            entry = (Entry)FREE.removeFirst();
            if (entry.bufferAllocator.pointer == 0L) {
                BUFFER_ALLOCATOR_MAPPING.remove((Object)entry.bufferAllocator);
                entry = new Entry(new ByteBufferBuilder(256));
            }
        }
        IN_USE.add((Object)entry);
        BUFFER_ALLOCATOR_MAPPING.put((Object)entry.bufferAllocator, (Object)entry);
        entry.onBorrow();
        return entry.bufferAllocator;
    }

    public static void returnBufferAllocatorSafe(ByteBufferBuilder bufferAllocator) {
        RenderSystem.assertOnRenderThread();
        Entry entry = (Entry)BUFFER_ALLOCATOR_MAPPING.get((Object)bufferAllocator);
        if (!IN_USE.remove((Object)entry)) {
            return;
        }
        entry.onReturn();
        FREE.addFirst((Object)entry);
    }

    public static int getSize() {
        return FREE.size() + IN_USE.size();
    }

    public static void onEndFrame() {
        if (!IN_USE.isEmpty()) {
            boolean leak = IN_USE.removeIf(entry -> {
                if (entry.inUseOverMultipleFrames) {
                    entry.onReturn();
                    FREE.addFirst(entry);
                    return true;
                }
                return false;
            });
            if (leak) {
                ImmediatelyFast.LOGGER.warn("Some BufferAllocators were not returned to the pool. Forcibly reclaiming them to prevent a memory leak.");
            }
            for (Entry entry2 : IN_USE) {
                entry2.inUseOverMultipleFrames = true;
            }
        }
        FREE.removeIf(entry -> {
            if (entry.shouldBeClosed()) {
                entry.bufferAllocator.close();
                BUFFER_ALLOCATOR_MAPPING.remove((Object)entry.bufferAllocator);
                return true;
            }
            return false;
        });
    }

    private static class Entry {
        private final ByteBufferBuilder bufferAllocator;
        private long lastAccessTime;
        private boolean inUseOverMultipleFrames;

        public Entry(ByteBufferBuilder bufferAllocator) {
            this.bufferAllocator = bufferAllocator;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public boolean shouldBeClosed() {
            return System.currentTimeMillis() - this.lastAccessTime > 60000L;
        }

        public void onBorrow() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public void onReturn() {
            this.bufferAllocator.discard();
            this.inUseOverMultipleFrames = false;
        }
    }
}

