/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.structurecontrol.mixin;

import com.crackerjackbox.structurecontrol.Constants;
import com.crackerjackbox.structurecontrol.data.StructureCheckData;
import com.crackerjackbox.structurecontrol.platform.Services;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public abstract class StructureMix {
    @Unique
    private StructureCheckData structureControl$structureCheckData;

    @Unique
    private void structureControl$loadData() {
        if (this.structureControl$structureCheckData == null) {
            this.structureControl$structureCheckData = StructureCheckData.getOrCreate();
        }
    }

    @Unique
    private Vec3 structureControl$getCenter(Structure structure, RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome) {
        StructurePiecesBuilder structurepiecesbuilder;
        Structure.GenerationContext structure$generationcontext = new Structure.GenerationContext(registryAccess, chunkGenerator, biomeSource, randomState, structureTemplateManager, seed, chunkPos, heightAccessor, validBiome);
        Optional optional = structure.findValidGenerationPoint(structure$generationcontext);
        if (optional.isPresent() && !(structurepiecesbuilder = ((Structure.GenerationStub)optional.get()).getPiecesBuilder()).build().isEmpty()) {
            return ((Structure.GenerationStub)optional.get()).position().getCenter();
        }
        return null;
    }

    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    public void generate(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> validBiome, CallbackInfoReturnable<StructureStart> cir) {
        Holder.Direct structure = new Holder.Direct((Object)((Structure)this));
        Vec3 centerPos = this.structureControl$getCenter((Structure)structure.value(), registryAccess, chunkGenerator, biomeSource, randomState, structureTemplateManager, seed, chunkPos, references, heightAccessor, validBiome);
        if (centerPos == null) {
            return;
        }
        this.structureControl$loadData();
        String extraData = "Position " + chunkPos.getWorldPosition().getX() + " " + chunkPos.getWorldPosition().getY() + " " + chunkPos.getWorldPosition().getZ() + ", Center " + centerPos.x + " " + centerPos.y + " " + centerPos.z;
        if (((Structure)structure.value()).type() == StructureType.STRONGHOLD) {
            if (this.structureControl$structureCheckData.checkMax("generateStronghold", Services.PLATFORM.config().generateStronghold(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.RUINED_PORTAL) {
            if (this.structureControl$structureCheckData.checkMax("generateRuinedPortal", Services.PLATFORM.config().generateRuinedPortal(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.BURIED_TREASURE) {
            if (this.structureControl$structureCheckData.checkMax("generateBuriedTreasure", Services.PLATFORM.config().generateBuriedTreasure(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.DESERT_PYRAMID) {
            if (this.structureControl$structureCheckData.checkMax("generateDesertPyramid", Services.PLATFORM.config().generateDesertPyramid(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.END_CITY) {
            if (this.structureControl$structureCheckData.checkMax("generateEndCity", Services.PLATFORM.config().generateEndCity(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.IGLOO) {
            if (this.structureControl$structureCheckData.checkMax("generateIgloo", Services.PLATFORM.config().generateIgloo(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.SHIPWRECK) {
            if (this.structureControl$structureCheckData.checkMax("generateShipwreck", Services.PLATFORM.config().generateShipwreck(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.OCEAN_RUIN) {
            if (this.structureControl$structureCheckData.checkMax("generateOceanRuin", Services.PLATFORM.config().generateOceanRuin(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.OCEAN_MONUMENT) {
            if (this.structureControl$structureCheckData.checkMax("generateOceanMonument", Services.PLATFORM.config().generateOceanMonument(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.MINESHAFT) {
            if (this.structureControl$structureCheckData.checkMax("generateMineshaft", Services.PLATFORM.config().generateMineshaft(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.FORTRESS) {
            if (this.structureControl$structureCheckData.checkMax("generateFortress", Services.PLATFORM.config().generateFortress(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.JUNGLE_TEMPLE) {
            if (this.structureControl$structureCheckData.checkMax("generateJungleTemple", Services.PLATFORM.config().generateJungleTemple(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.WOODLAND_MANSION) {
            if (this.structureControl$structureCheckData.checkMax("generateWoodlandMansion", Services.PLATFORM.config().generateWoodlandMansion(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.SWAMP_HUT) {
            if (this.structureControl$structureCheckData.checkMax("generateSwampHut", Services.PLATFORM.config().generateSwampHut(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else if (((Structure)structure.value()).type() == StructureType.NETHER_FOSSIL) {
            if (this.structureControl$structureCheckData.checkMax("generateNetherFossil", Services.PLATFORM.config().generateNetherFossil(), extraData)) {
                cir.setReturnValue((Object)StructureStart.INVALID_START);
            }
        } else {
            ResourceLocation resourceLocation = registryAccess.registryOrThrow(Registries.STRUCTURE).getKey((Object)((Structure)structure.value()));
            if (resourceLocation != null) {
                String modName = resourceLocation.getNamespace();
                String structureName = resourceLocation.getPath();
                if (Services.PLATFORM.config().logDebug()) {
                    Constants.LOG.info("Dynamic Structure Detected -> {}:{}", (Object)modName, (Object)structureName);
                }
                if (Objects.equals(modName, "minecraft")) {
                    switch (structureName) {
                        case "ancient_city": {
                            if (!this.structureControl$structureCheckData.checkMax("generateAncientCity", Services.PLATFORM.config().generateAncientCity(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "bastion_remnant": {
                            if (!this.structureControl$structureCheckData.checkMax("generateBastionRemnant", Services.PLATFORM.config().generateBastionRemnant(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "mansion": {
                            if (!this.structureControl$structureCheckData.checkMax("generateMansion", Services.PLATFORM.config().generateMansion(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "pillager_outpost": {
                            if (!this.structureControl$structureCheckData.checkMax("generatePillagerOutpost", Services.PLATFORM.config().generatePillagerOutpost(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "trail_ruins": {
                            if (!this.structureControl$structureCheckData.checkMax("generateTrailRuins", Services.PLATFORM.config().generateTrailRuins(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "trial_chambers": {
                            if (!this.structureControl$structureCheckData.checkMax("generateTrialChambers", Services.PLATFORM.config().generateTrialChambers(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "village_desert": {
                            if (!this.structureControl$structureCheckData.checkMax("generateVillageDesert", Services.PLATFORM.config().generateVillageDesert(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "village_plains": {
                            if (!this.structureControl$structureCheckData.checkMax("generateVillagePlains", Services.PLATFORM.config().generateVillagePlains(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "village_savanna": {
                            if (!this.structureControl$structureCheckData.checkMax("generateVillageSavanna", Services.PLATFORM.config().generateVillageSavanna(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "village_snowy": {
                            if (!this.structureControl$structureCheckData.checkMax("generateVillageSnowy", Services.PLATFORM.config().generateVillageSnowy(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                        case "village_taiga": {
                            if (!this.structureControl$structureCheckData.checkMax("generateVillageTaiga", Services.PLATFORM.config().generateVillageTaiga(), extraData)) break;
                            cir.setReturnValue((Object)StructureStart.INVALID_START);
                            return;
                        }
                    }
                }
                if (this.structureControl$structureCheckData.checkJigsawMax(modName, structureName, extraData)) {
                    cir.setReturnValue((Object)StructureStart.INVALID_START);
                }
            } else if (Services.PLATFORM.config().logDebug()) {
                Constants.LOG.warn("Unknown resourceLocation");
            }
        }
    }
}

