/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.structurecontrol.mixin;

import com.crackerjackbox.structurecontrol.Constants;
import com.crackerjackbox.structurecontrol.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FireBlock.class})
public abstract class FireBlockMix {
    @Inject(method={"onPlace"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving, CallbackInfo ci) {
        if (!Services.PLATFORM.config().activateNetherPortal() && oldState.getBlock() == Blocks.AIR) {
            if (Constants.NETHER_PORTAL_BLOCKS.isEmpty()) {
                Constants.setNetherPortalBlocks(Services.PLATFORM.config().activateNetherPortalBlocks());
            }
            if (this.structureControl$isObsidian(level, pos.below()) || this.structureControl$isObsidian(level, pos.above()) || this.structureControl$isObsidian(level, pos.north()) || this.structureControl$isObsidian(level, pos.south()) || this.structureControl$isObsidian(level, pos.east()) || this.structureControl$isObsidian(level, pos.west())) {
                ci.cancel();
            }
        }
    }

    @Unique
    private boolean structureControl$isObsidian(Level level, BlockPos blockPos) {
        return Constants.NETHER_PORTAL_BLOCKS.contains(BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(blockPos).getBlock()).toString());
    }
}

