/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.structurecontrol.mixin;

import com.crackerjackbox.structurecontrol.Constants;
import com.crackerjackbox.structurecontrol.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMix {
    @Unique
    private static boolean structureControl$deadLockMain = false;
    @Unique
    private static boolean structureControl$deadLockThread = false;

    @Inject(method={"getNearestGeneratedStructure(Ljava/util/Set;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/level/StructureManager;IIIZJLnet/minecraft/world/level/levelgen/structure/placement/RandomSpreadStructurePlacement;)Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getNearestGeneratedStructure(Set<Holder<Structure>> structureHoldersSet, LevelReader level, StructureManager structureManager, int x, int y, int z, boolean skipKnownStructures, long seed, RandomSpreadStructurePlacement spreadPlacement, CallbackInfoReturnable<Pair<BlockPos, Holder<Structure>>> cir) {
        if (!structureControl$deadLockMain) {
            structureControl$deadLockMain = true;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    structureControl$deadLockThread = true;
                }
            }, 10000L);
        }
        if (structureControl$deadLockThread) {
            if (Services.PLATFORM.config().logDebug()) {
                Constants.LOG.info("DeadLock RESET");
            }
            cir.setReturnValue(null);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    structureControl$deadLockMain = false;
                    structureControl$deadLockThread = false;
                }
            }, 1000L);
        }
    }
}

