/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.structurecontrol.data;

import com.crackerjackbox.structurecontrol.Constants;
import com.crackerjackbox.structurecontrol.platform.Services;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class StructureCheckData
extends SavedData {
    public static final String GENERATE_STRONGHOLD_KEY = "generateStronghold";
    public static final String GENERATE_RUINED_PORTAL_KEY = "generateRuinedPortal";
    public static final String GENERATE_BURIED_TREASURE_KEY = "generateBuriedTreasure";
    public static final String GENERATE_DESERT_PYRAMID_KEY = "generateDesertPyramid";
    public static final String GENERATE_END_CITY_KEY = "generateEndCity";
    public static final String GENERATE_FORTRESS_KEY = "generateFortress";
    public static final String GENERATE_IGLOO_KEY = "generateIgloo";
    public static final String GENERATE_JUNGLE_TEMPLE_KEY = "generateJungleTemple";
    public static final String GENERATE_MINESHAFT_KEY = "generateMineshaft";
    public static final String GENERATE_NETHER_FOSSIL_KEY = "generateNetherFossil";
    public static final String GENERATE_OCEAN_MONUMENT_KEY = "generateOceanMonument";
    public static final String GENERATE_OCEAN_RUIN_KEY = "generateOceanRuin";
    public static final String GENERATE_SHIPWRECK_KEY = "generateShipwreck";
    public static final String GENERATE_SWAMP_HUT_KEY = "generateSwampHut";
    public static final String GENERATE_WOODLAND_MANSION_KEY = "generateWoodlandMansion";
    public static final String GENERATE_ANCIENT_CITY_KEY = "generateAncientCity";
    public static final String GENERATE_BASTION_REMNANT_KEY = "generateBastionRemnant";
    public static final String GENERATE_MANSION_KEY = "generateMansion";
    public static final String GENERATE_PILLAGER_OUTPOST_KEY = "generatePillagerOutpost";
    public static final String GENERATE_TRAIL_RUINS_KEY = "generateTrailRuins";
    public static final String GENERATE_TRIAL_CHAMBERS_KEY = "generateTrialChambers";
    public static final String GENERATE_VILLAGE_DESERT_KEY = "generateVillageDesert";
    public static final String GENERATE_VILLAGE_PLAINS_KEY = "generateVillagePlains";
    public static final String GENERATE_VILLAGE_SAVANNA_KEY = "generateVillageSavanna";
    public static final String GENERATE_VILLAGE_SNOWY_KEY = "generateVillageSnowy";
    public static final String GENERATE_VILLAGE_TAIGA_KEY = "generateVillageTaiga";
    public static MinecraftServer server;
    private static final HashMap<String, StructureMax> jigsawStructures;
    private final HashMap<String, Integer> maxValuesData;

    protected StructureCheckData(HashMap<String, Integer> maxValuesData) {
        this.maxValuesData = maxValuesData;
    }

    public static StructureCheckData getOrCreate() {
        String userJigsawStructures = Services.PLATFORM.config().generateModdedStructure();
        if (userJigsawStructures.contains(":")) {
            String[] jigsawStructureArray = userJigsawStructures.contains(",") ? (String[])Arrays.stream(userJigsawStructures.split(",")).map(String::trim).toArray(String[]::new) : new String[]{userJigsawStructures.trim()};
            for (String jigsawStructure : jigsawStructureArray) {
                String[] parts = jigsawStructure.split(":");
                if (parts.length == 3) {
                    StructureMax structureMax = new StructureMax(parts[0], parts[1], NumberUtils.toInt((String)parts[2], (int)0));
                    jigsawStructures.put(structureMax.key(), structureMax);
                    continue;
                }
                Constants.LOG.warn("Problem parsing \"{}\" from generateModdedStructure, only found {} parts", (Object)jigsawStructure, (Object)parts.length);
            }
        }
        if (Services.PLATFORM.config().logDebug()) {
            Constants.LOG.info("Found {} dynamic structures to control", (Object)jigsawStructures.size());
        }
        return (StructureCheckData)Objects.requireNonNull(server.getLevel(ServerLevel.OVERWORLD)).getDataStorage().computeIfAbsent(new SavedData.Factory(StructureCheckData::create, StructureCheckData::load, DataFixTypes.OPTIONS), "structurecontrol");
    }

    public static StructureCheckData load(CompoundTag nbt, HolderLookup.Provider registries) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(GENERATE_STRONGHOLD_KEY, nbt.getInt(GENERATE_STRONGHOLD_KEY));
        map.put(GENERATE_RUINED_PORTAL_KEY, nbt.getInt(GENERATE_RUINED_PORTAL_KEY));
        map.put(GENERATE_BURIED_TREASURE_KEY, nbt.getInt(GENERATE_BURIED_TREASURE_KEY));
        map.put(GENERATE_DESERT_PYRAMID_KEY, nbt.getInt(GENERATE_DESERT_PYRAMID_KEY));
        map.put(GENERATE_END_CITY_KEY, nbt.getInt(GENERATE_END_CITY_KEY));
        map.put(GENERATE_FORTRESS_KEY, nbt.getInt(GENERATE_FORTRESS_KEY));
        map.put(GENERATE_IGLOO_KEY, nbt.getInt(GENERATE_IGLOO_KEY));
        map.put(GENERATE_JUNGLE_TEMPLE_KEY, nbt.getInt(GENERATE_JUNGLE_TEMPLE_KEY));
        map.put(GENERATE_MINESHAFT_KEY, nbt.getInt(GENERATE_MINESHAFT_KEY));
        map.put(GENERATE_NETHER_FOSSIL_KEY, nbt.getInt(GENERATE_NETHER_FOSSIL_KEY));
        map.put(GENERATE_OCEAN_MONUMENT_KEY, nbt.getInt(GENERATE_OCEAN_MONUMENT_KEY));
        map.put(GENERATE_OCEAN_RUIN_KEY, nbt.getInt(GENERATE_OCEAN_RUIN_KEY));
        map.put(GENERATE_SHIPWRECK_KEY, nbt.getInt(GENERATE_SHIPWRECK_KEY));
        map.put(GENERATE_SWAMP_HUT_KEY, nbt.getInt(GENERATE_SWAMP_HUT_KEY));
        map.put(GENERATE_WOODLAND_MANSION_KEY, nbt.getInt(GENERATE_WOODLAND_MANSION_KEY));
        map.put(GENERATE_ANCIENT_CITY_KEY, nbt.getInt(GENERATE_ANCIENT_CITY_KEY));
        map.put(GENERATE_BASTION_REMNANT_KEY, nbt.getInt(GENERATE_BASTION_REMNANT_KEY));
        map.put(GENERATE_MANSION_KEY, nbt.getInt(GENERATE_MANSION_KEY));
        map.put(GENERATE_PILLAGER_OUTPOST_KEY, nbt.getInt(GENERATE_PILLAGER_OUTPOST_KEY));
        map.put(GENERATE_TRAIL_RUINS_KEY, nbt.getInt(GENERATE_TRAIL_RUINS_KEY));
        map.put(GENERATE_TRIAL_CHAMBERS_KEY, nbt.getInt(GENERATE_TRIAL_CHAMBERS_KEY));
        map.put(GENERATE_VILLAGE_DESERT_KEY, nbt.getInt(GENERATE_VILLAGE_DESERT_KEY));
        map.put(GENERATE_VILLAGE_PLAINS_KEY, nbt.getInt(GENERATE_VILLAGE_PLAINS_KEY));
        map.put(GENERATE_VILLAGE_SAVANNA_KEY, nbt.getInt(GENERATE_VILLAGE_SAVANNA_KEY));
        map.put(GENERATE_VILLAGE_SNOWY_KEY, nbt.getInt(GENERATE_VILLAGE_SNOWY_KEY));
        map.put(GENERATE_VILLAGE_TAIGA_KEY, nbt.getInt(GENERATE_VILLAGE_TAIGA_KEY));
        jigsawStructures.forEach((key, value) -> map.put((String)key, nbt.getInt(value.key())));
        return new StructureCheckData(map);
    }

    public static StructureCheckData create() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(GENERATE_STRONGHOLD_KEY, 0);
        map.put(GENERATE_RUINED_PORTAL_KEY, 0);
        map.put(GENERATE_BURIED_TREASURE_KEY, 0);
        map.put(GENERATE_DESERT_PYRAMID_KEY, 0);
        map.put(GENERATE_END_CITY_KEY, 0);
        map.put(GENERATE_FORTRESS_KEY, 0);
        map.put(GENERATE_IGLOO_KEY, 0);
        map.put(GENERATE_JUNGLE_TEMPLE_KEY, 0);
        map.put(GENERATE_MINESHAFT_KEY, 0);
        map.put(GENERATE_NETHER_FOSSIL_KEY, 0);
        map.put(GENERATE_OCEAN_MONUMENT_KEY, 0);
        map.put(GENERATE_OCEAN_RUIN_KEY, 0);
        map.put(GENERATE_SHIPWRECK_KEY, 0);
        map.put(GENERATE_SWAMP_HUT_KEY, 0);
        map.put(GENERATE_WOODLAND_MANSION_KEY, 0);
        map.put(GENERATE_ANCIENT_CITY_KEY, 0);
        map.put(GENERATE_BASTION_REMNANT_KEY, 0);
        map.put(GENERATE_MANSION_KEY, 0);
        map.put(GENERATE_PILLAGER_OUTPOST_KEY, 0);
        map.put(GENERATE_TRAIL_RUINS_KEY, 0);
        map.put(GENERATE_TRIAL_CHAMBERS_KEY, 0);
        map.put(GENERATE_VILLAGE_DESERT_KEY, 0);
        map.put(GENERATE_VILLAGE_PLAINS_KEY, 0);
        map.put(GENERATE_VILLAGE_SAVANNA_KEY, 0);
        map.put(GENERATE_VILLAGE_SNOWY_KEY, 0);
        map.put(GENERATE_VILLAGE_TAIGA_KEY, 0);
        jigsawStructures.forEach((key, value) -> map.put((String)key, 0));
        return new StructureCheckData(map);
    }

    public boolean checkMax(String key, Integer max, String extraData) {
        if (Services.PLATFORM.config().logDebug()) {
            Constants.LOG.info("checkMax key {}, value {}, max {}, extra: {}", new Object[]{key, this.maxValuesData.get(key), max, extraData});
        }
        if (max != -1 && this.maxValuesData.get(key) >= max) {
            if (Services.PLATFORM.config().logDebug()) {
                Constants.LOG.info("checkMax key {} CANCEL", (Object)key);
            }
            return true;
        }
        this.maxValuesData.replace(key, this.maxValuesData.get(key) + 1);
        if (Services.PLATFORM.config().logDebug()) {
            Constants.LOG.info("checkMax INCREASE key {}, new value {}", (Object)key, (Object)this.maxValuesData.get(key));
        }
        this.setDirty();
        return false;
    }

    public boolean checkJigsawMax(String mod, String structure, String extraData) {
        String jigsawWildcardKey = new StructureMax(mod, "*").key();
        StructureMax jigsawWildcardStructure = jigsawStructures.get(jigsawWildcardKey);
        if (jigsawWildcardStructure != null) {
            return this.checkMax(jigsawWildcardKey, jigsawWildcardStructure.max, extraData);
        }
        for (Map.Entry<String, StructureMax> entry : jigsawStructures.entrySet()) {
            String[] keys = entry.getKey().split("-");
            StructureMax value = entry.getValue();
            if (keys.length <= 1 || !keys[0].equals(mod) || !keys[1].endsWith("*")) continue;
            String partialStructure = keys[1].substring(0, keys[1].indexOf("*"));
            if (Services.PLATFORM.config().logDebug()) {
                Constants.LOG.info("Matching partial for mod {}, structure {}, partial {}", new Object[]{keys[0], structure, partialStructure});
            }
            if (!structure.startsWith(partialStructure)) continue;
            if (Services.PLATFORM.config().logDebug()) {
                Constants.LOG.info("Check Max on mod {}, structure {}, partial {}", new Object[]{keys[0], structure, partialStructure});
            }
            return this.checkMax(value.key(), value.max, extraData);
        }
        String jigsawKey = new StructureMax(mod, structure).key();
        StructureMax jigsawStructure = jigsawStructures.get(jigsawKey);
        if (jigsawStructure != null) {
            return this.checkMax(jigsawKey, jigsawStructure.max, extraData);
        }
        return false;
    }

    @NotNull
    public CompoundTag save(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        compoundTag.putInt(GENERATE_STRONGHOLD_KEY, this.maxValuesData.get(GENERATE_STRONGHOLD_KEY).intValue());
        compoundTag.putInt(GENERATE_RUINED_PORTAL_KEY, this.maxValuesData.get(GENERATE_RUINED_PORTAL_KEY).intValue());
        compoundTag.putInt(GENERATE_BURIED_TREASURE_KEY, this.maxValuesData.get(GENERATE_BURIED_TREASURE_KEY).intValue());
        compoundTag.putInt(GENERATE_DESERT_PYRAMID_KEY, this.maxValuesData.get(GENERATE_DESERT_PYRAMID_KEY).intValue());
        compoundTag.putInt(GENERATE_END_CITY_KEY, this.maxValuesData.get(GENERATE_END_CITY_KEY).intValue());
        compoundTag.putInt(GENERATE_FORTRESS_KEY, this.maxValuesData.get(GENERATE_FORTRESS_KEY).intValue());
        compoundTag.putInt(GENERATE_IGLOO_KEY, this.maxValuesData.get(GENERATE_IGLOO_KEY).intValue());
        compoundTag.putInt(GENERATE_JUNGLE_TEMPLE_KEY, this.maxValuesData.get(GENERATE_JUNGLE_TEMPLE_KEY).intValue());
        compoundTag.putInt(GENERATE_MINESHAFT_KEY, this.maxValuesData.get(GENERATE_MINESHAFT_KEY).intValue());
        compoundTag.putInt(GENERATE_NETHER_FOSSIL_KEY, this.maxValuesData.get(GENERATE_NETHER_FOSSIL_KEY).intValue());
        compoundTag.putInt(GENERATE_OCEAN_MONUMENT_KEY, this.maxValuesData.get(GENERATE_OCEAN_MONUMENT_KEY).intValue());
        compoundTag.putInt(GENERATE_OCEAN_RUIN_KEY, this.maxValuesData.get(GENERATE_OCEAN_RUIN_KEY).intValue());
        compoundTag.putInt(GENERATE_SHIPWRECK_KEY, this.maxValuesData.get(GENERATE_SHIPWRECK_KEY).intValue());
        compoundTag.putInt(GENERATE_SWAMP_HUT_KEY, this.maxValuesData.get(GENERATE_SWAMP_HUT_KEY).intValue());
        compoundTag.putInt(GENERATE_WOODLAND_MANSION_KEY, this.maxValuesData.get(GENERATE_WOODLAND_MANSION_KEY).intValue());
        compoundTag.putInt(GENERATE_ANCIENT_CITY_KEY, this.maxValuesData.get(GENERATE_ANCIENT_CITY_KEY).intValue());
        compoundTag.putInt(GENERATE_BASTION_REMNANT_KEY, this.maxValuesData.get(GENERATE_BASTION_REMNANT_KEY).intValue());
        compoundTag.putInt(GENERATE_MANSION_KEY, this.maxValuesData.get(GENERATE_MANSION_KEY).intValue());
        compoundTag.putInt(GENERATE_PILLAGER_OUTPOST_KEY, this.maxValuesData.get(GENERATE_PILLAGER_OUTPOST_KEY).intValue());
        compoundTag.putInt(GENERATE_TRAIL_RUINS_KEY, this.maxValuesData.get(GENERATE_TRAIL_RUINS_KEY).intValue());
        compoundTag.putInt(GENERATE_TRIAL_CHAMBERS_KEY, this.maxValuesData.get(GENERATE_TRIAL_CHAMBERS_KEY).intValue());
        compoundTag.putInt(GENERATE_VILLAGE_DESERT_KEY, this.maxValuesData.get(GENERATE_VILLAGE_DESERT_KEY).intValue());
        compoundTag.putInt(GENERATE_VILLAGE_PLAINS_KEY, this.maxValuesData.get(GENERATE_VILLAGE_PLAINS_KEY).intValue());
        compoundTag.putInt(GENERATE_VILLAGE_SAVANNA_KEY, this.maxValuesData.get(GENERATE_VILLAGE_SAVANNA_KEY).intValue());
        compoundTag.putInt(GENERATE_VILLAGE_SNOWY_KEY, this.maxValuesData.get(GENERATE_VILLAGE_SNOWY_KEY).intValue());
        compoundTag.putInt(GENERATE_VILLAGE_TAIGA_KEY, this.maxValuesData.get(GENERATE_VILLAGE_TAIGA_KEY).intValue());
        jigsawStructures.forEach((key, value) -> {
            if (Services.PLATFORM.config().logDebug()) {
                Constants.LOG.info("Save {} with {}", key, value);
            }
            compoundTag.putInt(key, this.maxValuesData.get(key).intValue());
        });
        return compoundTag;
    }

    static {
        jigsawStructures = new HashMap();
    }

    public static class StructureMax {
        public String mod;
        public String structure;
        public Integer max;

        StructureMax(String mod, String structure, Integer max) {
            this.mod = mod;
            this.structure = structure;
            this.max = max;
        }

        StructureMax(String mod, String structure) {
            this.mod = mod;
            this.structure = structure;
            this.max = 0;
        }

        String key() {
            return this.mod + "-" + this.structure;
        }
    }
}

