/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.structurecontrol.command;

import com.crackerjackbox.structurecontrol.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class GenericCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"structurecontrol").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"find").executes(source -> {
            GenericCommand.findStructures((CommandContext<CommandSourceStack>)source);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.hasPermission(4))).executes(source -> {
            GenericCommand.reload((CommandContext<CommandSourceStack>)source);
            return 1;
        })))).requires(source -> source.hasPermission(0))).then(Commands.literal((String)"ver").executes(source -> {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)"\u00a72Structure Control, version 1.8.5 by \u00a79Ohayden"), !((CommandSourceStack)source.getSource()).isPlayer());
            return 1;
        })));
    }

    private static void reload(CommandContext<CommandSourceStack> source) {
        ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)(Services.PLATFORM.reload() ? "\u00a7aReload finished" : "\u00a74Reload failed")), !((CommandSourceStack)source.getSource()).isPlayer());
    }

    private static void findStructures(CommandContext<CommandSourceStack> source) {
        if (!((CommandSourceStack)source.getSource()).isPlayer()) {
            return;
        }
        ServerPlayer player = ((CommandSourceStack)source.getSource()).getPlayer();
        if (player == null) {
            return;
        }
        ServerLevel level = ((CommandSourceStack)source.getSource()).getLevel();
        BlockPos playerPos = player.blockPosition();
        BlockPos centerPos = WorldCoordinates.absolute((double)playerPos.getX(), (double)playerPos.getY(), (double)playerPos.getZ()).getBlockPos((CommandSourceStack)source.getSource());
        List structureStarts = level.structureManager().startsForStructure(new ChunkPos(centerPos), s -> true);
        List<Structure> structures = structureStarts.stream().filter(structureStart -> structureStart.getBoundingBox().isInside((Vec3i)centerPos)).map(StructureStart::getStructure).toList();
        if (structures.isEmpty()) {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)"\u00a74Couldn't find any structures here!"), !((CommandSourceStack)source.getSource()).isPlayer());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("\u00a7aWe found the following:\u00a7e");
        for (Structure structure : structures) {
            ResourceLocation key = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)structure);
            if (key == null) continue;
            stringBuilder.append("\n ").append(key.getNamespace()).append(":").append(key.getPath());
        }
        MutableComponent component = Component.literal((String)stringBuilder.toString());
        ((CommandSourceStack)source.getSource()).sendSuccess(() -> GenericCommand.lambda$findStructures$11((Component)component), !((CommandSourceStack)source.getSource()).isPlayer());
    }

    private static /* synthetic */ Component lambda$findStructures$11(Component component) {
        return component;
    }
}

