/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.libnolij.collect;

public class SlidingLongBuffer {
    private int maxSize;
    private long[] array;
    private int base = 0;
    private int size = 0;

    public SlidingLongBuffer(int maxSize) {
        this.maxSize = maxSize;
        this.array = new long[maxSize + 1];
    }

    private int getIndex(int b, int i) {
        return (b + i) % this.array.length;
    }

    private int getIndex(int i) {
        return this.getIndex(this.base, i);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.maxSize;
    }

    public boolean any() {
        return this.size != 0;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.size;
    }

    public long get(int index) {
        if (this.size == 0 || index < 0 || index >= this.size) {
            return 0L;
        }
        return this.array[this.getIndex(index)];
    }

    public long peek() {
        return this.get(this.size - 1);
    }

    public long getUnsafe(int index) {
        return this.array[this.getIndex(index)];
    }

    public long peekUnsafe() {
        return this.getUnsafe(this.size - 1);
    }

    public synchronized void push(long value) {
        if (this.size < this.maxSize) {
            this.array[this.getIndex((int)this.base, (int)this.size++)] = value;
        } else {
            this.array[this.getIndex((int)this.base++, (int)this.size)] = value;
            this.base %= this.array.length;
        }
    }

    public synchronized void pop() {
        this.base = (this.base + 1) % this.array.length;
        --this.size;
    }

    public synchronized void resize(int newMaxSize) {
        if (newMaxSize == this.maxSize) {
            return;
        }
        long[] newArray = new long[newMaxSize + 1];
        if (newMaxSize > this.size) {
            this.copy(this.size, newArray, this.base);
        } else {
            int offsetBase = this.getIndex(this.base, this.size - newMaxSize);
            this.copy(newMaxSize, newArray, offsetBase);
            this.size = newMaxSize;
        }
        this.base = 0;
        this.array = newArray;
        this.maxSize = newMaxSize;
    }

    private void copy(int amount, long[] newArray, int offsetBase) {
        int distanceToEdge = this.array.length - offsetBase;
        if (amount <= distanceToEdge) {
            System.arraycopy(this.array, offsetBase, newArray, 0, amount);
        } else {
            System.arraycopy(this.array, offsetBase, newArray, 0, distanceToEdge);
            System.arraycopy(this.array, 0, newArray, distanceToEdge, amount - distanceToEdge);
        }
    }
}

