/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.widgets;

import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.ITMRVSlotWidget;
import dev.nolij.toomanyrecipeviewers.impl.widget.ScrollBarWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.Nullable;

public class ScrollGridWidget
implements IScrollGridWidget {
    private static final int SLOT_SIZE = 18;
    private static final int SCROLL_BAR_WIDTH = 10;
    private final List<ITMRVSlotWidget> slots = new ArrayList<ITMRVSlotWidget>();
    private final int columns;
    private final int visibleRows;
    private ImmutableRect2i rect;
    @Nullable
    private final ScrollBarWidget scrollBar;

    public ScrollGridWidget(WidgetHolder widgets, List<IRecipeSlotDrawable> slots, int columns, int visibleRows) {
        for (IRecipeSlotDrawable slot : slots) {
            if (slot instanceof ITMRVSlotWidget) {
                ITMRVSlotWidget tmrvSlotWidget = (ITMRVSlotWidget)((Object)slot);
                tmrvSlotWidget.drawBack(true);
                this.slots.add(tmrvSlotWidget);
                continue;
            }
            throw new IllegalStateException();
        }
        this.columns = columns;
        int rows = (int)Math.ceil((double)this.slots.size() / (double)columns);
        this.visibleRows = visibleRows;
        this.scrollBar = rows > visibleRows ? (ScrollBarWidget)widgets.add((Widget)new ScrollBarWidget(ImmutableRect2i.EMPTY, rows, visibleRows, this::updateGrid)) : null;
        this.rect = new ImmutableRect2i(0, 0, 18 * columns + (this.scrollBar == null ? 0 : 10), 18 * visibleRows);
        this.updateGrid();
    }

    private void updateGrid() {
        for (int i = 0; i < this.slots.size(); ++i) {
            int renderRow;
            ITMRVSlotWidget slot = this.slots.get(i);
            int column = i % this.columns;
            int row = i / this.columns;
            int n = renderRow = this.scrollBar == null ? row : row - this.scrollBar.getScroll();
            if (renderRow < 0 || renderRow >= this.visibleRows) {
                slot.setVisible(false);
                continue;
            }
            slot.setVisible(true);
            slot.setPosition(this.rect.x() + column * 18, this.rect.y() + renderRow * 18);
        }
    }

    @Override
    public ScreenRectangle getScreenRectangle() {
        return this.rect.toScreenRectangle();
    }

    @Override
    public IScrollGridWidget setPosition(int x, int y) {
        this.rect = this.rect.setPosition(x + 1, y);
        if (this.scrollBar != null) {
            this.scrollBar.setRect(this.rect.keepRight(10).addOffset(0, -1));
        }
        this.updateGrid();
        return this;
    }

    @Override
    public int getWidth() {
        return this.rect.width();
    }

    @Override
    public int getHeight() {
        return this.rect.height();
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double x, double y) {
        return Optional.empty();
    }

    @Override
    public ScreenPosition getPosition() {
        return this.rect.getScreenPosition();
    }
}

