/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.gui.screens.inventory;

import com.talhanation.smallships.SmallShipsMod;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.math.Kalkuel;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ShipContainerScreen
extends AbstractContainerScreen<ShipContainerMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)"textures/gui/ship_inventory.png");
    public static final int FONT_COLOR = 0x404040;
    private final int rowCount;
    private final int pageCount;
    private final int pageIndex;
    private final ContainerShip containerShip;
    private final int offset = 40;
    private int origLeftPos;
    private int origTopPos;

    public ShipContainerScreen(ShipContainerMenu shipContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)shipContainerMenu, inventory, component);
        this.imageHeight = 114 + ((ShipContainerMenu)this.getMenu()).getRowCount() * 18;
        this.imageWidth = 256;
        this.inventoryLabelY = this.imageHeight - 94;
        this.containerShip = shipContainerMenu.getContainerShip();
        this.rowCount = ((ShipContainerMenu)this.getMenu()).getRowCount();
        this.pageCount = ((ShipContainerMenu)this.getMenu()).getPageCount();
        this.pageIndex = ((ShipContainerMenu)this.getMenu()).getPageIndex();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        int k = 40 + (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RESOURCE_LOCATION, k, l, 0, 0, this.imageWidth, this.rowCount * 18 + 17);
        guiGraphics.blit(RESOURCE_LOCATION, k, l + this.rowCount * 18 + 17, 0, 126, this.imageWidth, 96);
    }

    protected void init() {
        this.origLeftPos = this.leftPos;
        this.origTopPos = this.topPos;
        this.leftPos = 40 + (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        if (this.minecraft == null || this.minecraft.player == null) {
            SmallShipsMod.LOGGER.error("Minecraft client or LocalPlayer is null?! Couldn't render page buttons.");
            return;
        }
        Button backward = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"<"), button -> ((ShipContainerMenu)this.getMenu()).clickMenuButton((Player)this.minecraft.player, -1)).pos(this.leftPos + 115, this.topPos + 125).size(12, 12).build());
        backward.active = this.pageCount > 1 && this.pageIndex + 1 > 1;
        Button forward = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)">"), button -> ((ShipContainerMenu)this.getMenu()).clickMenuButton((Player)this.minecraft.player, 1)).pos(this.leftPos + 157, this.topPos + 125).size(12, 12).build());
        forward.active = this.pageCount > 1 && this.pageIndex + 1 < this.pageCount;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        int maxSpeed;
        String unit;
        super.renderLabels(guiGraphics, i, j);
        String name = this.containerShip.getDisplayName().getString();
        String smallShipTypeRaw = this.containerShip.getType().getDescription().getString();
        String smallShipType = smallShipTypeRaw.substring(0, 1).toUpperCase() + smallShipTypeRaw.substring(1);
        int currentPassengers = this.containerShip.getPassengers().size();
        int maxPassengers = this.containerShip.getMaxPassengers();
        int maxAttachment = 0;
        int currentAttachment = 0;
        ContainerShip containerShip = this.containerShip;
        if (containerShip instanceof Cannonable) {
            Cannonable cannonable = (Cannonable)((Object)containerShip);
            maxAttachment = cannonable.getMaxCannonPerSide() * 2;
            currentAttachment = cannonable.getCannonCount();
        } else {
            containerShip = this.containerShip;
            if (containerShip instanceof Shieldable) {
                Shieldable shieldable = (Shieldable)((Object)containerShip);
                maxAttachment = shieldable.getMaxShieldsPerSide() * 2;
                currentAttachment = shieldable.getShields().size();
            }
        }
        int dmg = (int)(this.containerShip.getDamage() * 100.0f / this.containerShip.getAttributes().maxHealth);
        int currentSpeed = switch ((Integer)SmallShipsConfig.Client.shipModSpeedUnit.get()) {
            default -> {
                unit = "km/h";
                maxSpeed = Mth.ceil((float)Kalkuel.getKilometerPerHour(this.containerShip.maxSpeed));
                yield Mth.ceil((float)Kalkuel.getKilometerPerHour(this.containerShip.getSpeed()));
            }
            case 1 -> {
                unit = "m/s";
                maxSpeed = Mth.ceil((float)Kalkuel.getMeterPerSecond(this.containerShip.maxSpeed));
                yield Mth.ceil((float)Kalkuel.getMeterPerSecond(this.containerShip.getSpeed()));
            }
            case 2 -> {
                unit = "knots";
                maxSpeed = Mth.ceil((float)Kalkuel.getKnots(this.containerShip.maxSpeed));
                yield Mth.ceil((float)Kalkuel.getKnots(this.containerShip.getSpeed()));
            }
            case 3 -> {
                unit = "mph";
                maxSpeed = Mth.ceil((float)Kalkuel.getMilesPerHour(this.containerShip.maxSpeed));
                yield Mth.ceil((float)Kalkuel.getMilesPerHour(this.containerShip.getSpeed()));
            }
        };
        int leftPos = 260;
        int leftPos2 = 323;
        int topPos = 38;
        int gap = 14;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.7f, 0.7f, 1.0f);
        String attachment = this.containerShip instanceof Shieldable ? "Shields:" : "Cannons:";
        guiGraphics.drawString(this.font, "Name:", leftPos, topPos + gap * 0, 0x404040, false);
        guiGraphics.drawString(this.font, "Type:", leftPos, topPos + gap * 1, 0x404040, false);
        guiGraphics.drawString(this.font, "Crew:", leftPos, topPos + gap * 2, 0x404040, false);
        guiGraphics.drawString(this.font, "Speed " + unit + ":", leftPos, topPos + gap * 3, 0x404040, false);
        guiGraphics.drawString(this.font, "Damage:", leftPos, topPos + gap * 4, 0x404040, false);
        guiGraphics.drawString(this.font, attachment, leftPos, topPos + gap * 5, 0x404040, false);
        guiGraphics.drawString(this.font, name, leftPos2, topPos + gap * 0, 0x404040, false);
        guiGraphics.drawString(this.font, smallShipType, leftPos2, topPos + gap * 1, 0x404040, false);
        guiGraphics.drawString(this.font, currentPassengers + "/" + maxPassengers, leftPos2, topPos + gap * 2, 0x404040, false);
        guiGraphics.drawString(this.font, currentSpeed + "/" + maxSpeed, leftPos2, topPos + gap * 3, 0x404040, false);
        guiGraphics.drawString(this.font, dmg + "%", leftPos2, topPos + gap * 4, 0x404040, false);
        guiGraphics.drawString(this.font, currentAttachment + "/" + maxAttachment, leftPos2, topPos + gap * 5, 0x404040, false);
        int xOffset = this.origLeftPos + (int)(133.0f - (float)Mth.floor((double)Math.log10(this.pageCount)) * 6.0f);
        int yOffset = this.origTopPos + this.rowCount * 18;
        if (this.pageCount > 1) {
            guiGraphics.drawString(this.font, this.pageIndex + 1 + "/" + this.pageCount, xOffset, yOffset, 0x404040, false);
        }
        guiGraphics.pose().popPose();
    }
}

