/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui.config;

import com.ezzenix.smoothgui.SmoothGui;
import com.ezzenix.smoothgui.config.AnimationDirection;
import com.ezzenix.smoothgui.config.AnimationStyle;
import com.ezzenix.smoothgui.config.ModConfig;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends Screen {
    Screen parentScreen;
    ModConfig config;

    public ModConfigScreen(Screen parentScreen) {
        super((Component)Component.literal((String)"Settings"));
        this.parentScreen = parentScreen;
        this.config = ModConfig.getConfig();
    }

    public static Screen create(Screen parentScreen) {
        return new ModConfigScreen(parentScreen);
    }

    protected void init() {
        int buttonWidth = 140;
        int buttonHeight = 20;
        int x = this.width / 2 - buttonWidth / 2;
        int y = this.height / 2 - buttonHeight / 2 - 75;
        int spacingX = 80;
        int spacingY = 25;
        this.addToggleOption(x - spacingX, y, buttonWidth, buttonHeight, "Enabled", () -> this.config.enableAnimation, val -> {
            this.config.enableAnimation = val;
        });
        this.addSliderOption(x - spacingX, y + spacingY, buttonWidth, buttonHeight, "Duration", 10, 600, () -> this.config.animationTime, (Integer val) -> {
            this.config.animationTime = val;
        });
        this.addSliderOption(x - spacingX, y + spacingY * 2, buttonWidth, buttonHeight, "Scale", 0.5, 3.0, () -> this.config.animationScale, (Double val) -> {
            this.config.animationScale = val;
        });
        this.addToggleOption(x + spacingX, y, buttonWidth, buttonHeight, "Fade Background", () -> this.config.fadeBackground, val -> {
            this.config.fadeBackground = val;
        });
        this.addEnumOption(x + spacingX, y + spacingY, buttonWidth, buttonHeight, "Direction", () -> this.config.animationDirection, val -> {
            this.config.animationDirection = val;
        }, AnimationDirection.values());
        this.addEnumOption(x + spacingX, y + spacingY * 2, buttonWidth, buttonHeight, "Style", () -> this.config.animationStyle, val -> {
            this.config.animationStyle = val;
        }, AnimationStyle.values());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Preview"), button -> {
            SmoothGui.lastScreenChangedTime = System.currentTimeMillis();
        }).bounds(this.width / 2 - buttonWidth / 4, y + spacingY * 6, buttonWidth / 2, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset").withStyle(ChatFormatting.RED), button -> {
            this.config.reset();
            this.clearWidgets();
            this.init();
        }).bounds(x - spacingX, y + spacingY * 5, buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parentScreen);
            }
        }).bounds(x + spacingX, y + spacingY * 5, buttonWidth, buttonHeight).build());
    }

    private void addToggleOption(int x, int y, int width, int height, String text, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        Button widget = Button.builder((Component)Component.literal((String)(text + ": ")).append((Component)(getter.get() != false ? Component.literal((String)"ON").withStyle(ChatFormatting.GREEN) : Component.literal((String)"OFF").withStyle(ChatFormatting.RED))), button -> {
            setter.accept((Boolean)getter.get() == false);
            button.setMessage((Component)Component.literal((String)(text + ": ")).append((Component)((Boolean)getter.get() != false ? Component.literal((String)"ON").withStyle(ChatFormatting.GREEN) : Component.literal((String)"OFF").withStyle(ChatFormatting.RED))));
        }).bounds(x, y, width, height).build();
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private void addSliderOption(int x, int y, int width, int height, final String label, final int min, final int max, Supplier<Integer> getter, final Consumer<Integer> setter) {
        int current = getter.get();
        double normalized = (double)(current - min) / (double)(max - min);
        AbstractSliderButton widget = new AbstractSliderButton(this, x, y, width, height, (Component)Component.literal((String)(label + ": " + String.valueOf(getter.get()) + "ms")), normalized){

            protected void updateMessage() {
                int valueInt = (int)(this.value * (double)(max - min)) + min;
                this.setMessage((Component)Component.literal((String)(label + ": " + valueInt + "ms")));
            }

            protected void applyValue() {
                int newValue = (int)(this.value * (double)(max - min)) + min;
                setter.accept(newValue);
            }
        };
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private void addSliderOption(int x, int y, int width, int height, final String label, final double min, final double max, Supplier<Double> getter, final Consumer<Double> setter) {
        double current = getter.get();
        double normalized = (current - min) / (max - min);
        AbstractSliderButton widget = new AbstractSliderButton(this, x, y, width, height, (Component)Component.literal((String)(label + ": " + String.valueOf(getter.get()))), normalized){

            private double getValue() {
                return (double)Math.round((this.value * (max - min) + min) * 20.0) / 20.0;
            }

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)(label + ": " + this.getValue())));
            }

            protected void applyValue() {
                setter.accept(this.getValue());
            }
        };
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private <T extends Enum<T>> void addEnumOption(int x, int y, int width, int height, String label, Supplier<T> getter, Consumer<T> setter, T[] values) {
        Button widget = Button.builder((Component)Component.literal((String)(label + ": ")).append((Component)Component.literal((String)((Enum)getter.get()).name()).withStyle(ChatFormatting.YELLOW)), button -> {
            Enum current = (Enum)getter.get();
            int index = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != current) continue;
                index = i;
                break;
            }
            int nextIndex = (index + 1) % values.length;
            setter.accept(values[nextIndex]);
            button.setMessage((Component)Component.literal((String)(label + ": ")).append((Component)Component.literal((String)values[nextIndex].name()).withStyle(ChatFormatting.YELLOW)));
        }).bounds(x, y, width, height).build();
        this.addRenderableWidget((GuiEventListener)widget);
    }

    public void removed() {
        this.config.save();
    }

    public void onClose() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen(this.parentScreen);
    }
}

