/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.vertex.BufferUploader;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.minecraft.PlayerPhysicsHealth;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.settings.mobs.MobPhysicsType;
import net.diebuddies.physics.vines.DynamicLoader;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public class MixinGameRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private List<AbstractClientPlayer> physicsmod$players = new ObjectArrayList();

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(DeltaTracker deltaTracker, boolean render, CallbackInfo info) {
        for (Map.Entry entry : PhysicsMod.getInstances().entrySet()) {
            PhysicsMod mod = (PhysicsMod)entry.getValue();
            while (!mod.sodiumRemoveRagdolls.isEmpty()) {
                Ragdoll ragdoll = mod.sodiumRemoveRagdolls.poll();
                mod.physicsWorld.removeRagdoll(ragdoll);
            }
        }
        LocalPlayer clientPlayer = this.minecraft.player;
        long currentTime = Util.getNanos();
        ObjectIterator it = PhysicsMod.getInstances().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Level level = (Level)entry.getKey();
            PhysicsMod mod = (PhysicsMod)entry.getValue();
            if (level instanceof ClientLevel) {
                ((DynamicLoader)((ClientLevel)level).getChunkSource()).setPhysicsMod(mod);
            }
            if ((double)(currentTime - mod.time) / 1000000.0 > 4000.0) {
                mod.time = currentTime;
            }
            double diff = (double)(currentTime - mod.time) / 1.0E9 * PhysicsMod.getPlaybackSpeed();
            PhysicsWorld physics = mod.getPhysicsWorld();
            if (!physics.isActive()) {
                physics.destroy();
                it.remove();
                continue;
            }
            VAO.storePreviouslyBoundState();
            physics.update(diff);
            VAO.restorePreviouslyBoundState();
            BufferUploader.reset();
            mod.time = currentTime;
            if (!(level instanceof ClientLevel)) continue;
            ClientLevel client = (ClientLevel)level;
            this.physicsmod$players.clear();
            this.physicsmod$players.addAll(client.players());
            for (AbstractClientPlayer player : this.physicsmod$players) {
                PlayerPhysicsHealth health = (PlayerPhysicsHealth)player;
                if (health.getPhysicsHealth() > 0.0f && player.getHealth() <= 0.0f && ConfigMobs.getMobSetting((Entity)player).getType() != MobPhysicsType.OFF) {
                    PhysicsMod.blockifyEntity(player.getCommandSenderWorld(), (LivingEntity)player);
                }
                health.setPhysicsHealth(player.getHealth());
            }
        }
    }
}

