/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={EntityRenderDispatcher.class})
public class MixinEntityRenderDispatcher {
    @Shadow
    private Map<EntityType<?>, EntityRenderer<?>> renderers;

    @Inject(at={@At(value="TAIL")}, method={"onResourceManagerReload"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onResourceManagerReload(ResourceManager manager, CallbackInfo ci, EntityRendererProvider.Context context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<EntityType<?>, EntityRenderer<?>> entry : this.renderers.entrySet()) {
            builder.put(entry.getKey(), entry.getValue());
        }
        this.renderers = builder.build();
        for (Map.Entry<EntityType<?>, EntityRenderer<?>> entry : this.renderers.entrySet()) {
            PhysicsMod.renderers.put(entry.getKey(), entry.getValue());
        }
        PhysicsMod.renderers.put(EntityType.PLAYER, null);
    }
}

