/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Set;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.common.NeoForge;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElementHelper;

public class GogglesProvider
implements IBlockComponentProvider {
    private static final ResourceLocation CREATE_OVERLAY_ID = ResourceLocation.fromNamespaceAndPath((String)"create", (String)"goggle_info");
    private static final Set<String> REMOVE_KEYS = Set.of("create.tooltip.chute.contains", "create.tooltip.deployer.contains");
    private final Block PISTON_EXTENSION_POLE = GogglesProvider.block("piston_extension_pole");

    private static Block block(String id) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)id));
    }

    public GogglesProvider() {
        NeoForge.EVENT_BUS.addListener(this::hideCreateOverlay);
    }

    private void hideCreateOverlay(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)CREATE_OVERLAY_ID) && IWailaConfig.get().getPlugin().get(CreatePlugin.GOGGLES)) {
            event.setCanceled(true);
        }
    }

    public ResourceLocation getUid() {
        return CreatePlugin.GOGGLES;
    }

    public void appendTooltip(ITooltip tooltip1, BlockAccessor accessor, IPluginConfig config) {
        boolean exceptionAdded;
        FluidTankBlockEntity tank;
        if (config.get(CreatePlugin.GOGGLES_DETAILED) && !accessor.showDetails()) {
            return;
        }
        Level world = accessor.getLevel();
        BlockPos pos = GoggleOverlayRenderer.proxiedOverlayPosition((Level)world, (BlockPos)accessor.getPosition());
        BlockEntity te = world.getBlockEntity(pos);
        boolean wearingGoggles = !config.get(CreatePlugin.REQUIRES_GOGGLES) || GogglesItem.isWearingGoggles((Player)accessor.getPlayer());
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation && !(te instanceof SpoutBlockEntity) && !(te instanceof ItemDrainBlockEntity) && !(te instanceof BasinBlockEntity) && (!(te instanceof FluidTankBlockEntity) || (tank = (FluidTankBlockEntity)te).getControllerBE() == null || tank.getControllerBE().boiler.isActive());
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, accessor.showDetails());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(CommonComponents.EMPTY);
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, accessor.showDetails());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (te instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)te).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (!hasHoveringInformation) {
            hasHoveringInformation = hoverAddedInformation = TrainRelocator.addToTooltip(tooltip, (boolean)accessor.showDetails());
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        tooltip.removeIf(c -> {
            for (Component sibling : c.getSiblings()) {
                TranslatableContents contents;
                ComponentContents patt0$temp = sibling.getContents();
                if (!(patt0$temp instanceof TranslatableContents) || !REMOVE_KEYS.contains((contents = (TranslatableContents)patt0$temp).getKey())) continue;
                return true;
            }
            return false;
        });
        tooltip.replaceAll(c -> {
            String text;
            ComponentContents patt1$temp = c.getContents();
            if (!(patt1$temp instanceof PlainTextContents.LiteralContents)) return c;
            PlainTextContents.LiteralContents $b$0 = (PlainTextContents.LiteralContents)patt1$temp;
            try {
                String patt2$temp;
                text = patt2$temp = $b$0.text();
                if (!text.startsWith("    ")) return c;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            MutableComponent mutableComponent = Component.literal((String)text.substring(4)).withStyle(c.getStyle());
            c.getSiblings().forEach(arg_0 -> ((MutableComponent)mutableComponent).append(arg_0));
            return mutableComponent;
        });
        BlockState state = world.getBlockState(pos);
        if (wearingGoggles && state.is(this.PISTON_EXTENSION_POLE)) {
            Direction[] directions = Iterate.directionsInAxis((Direction.Axis)((Direction)state.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis());
            int poles = 1;
            boolean pistonFound = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles(world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.getBlockState(pos.relative(dir, attachedPoles + 1)).getBlock() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(CommonComponents.EMPTY);
            }
            tooltip.add(CreateLang.translate((String)"gui.goggles.pole_length", (Object[])new Object[0]).text(" " + poles).component());
        }
        tooltip.stream().map(c -> {
            if (c.getString().isBlank()) {
                return IElementHelper.get().spacer(3, 3);
            }
            return IElementHelper.get().text(c);
        }).forEach(arg_0 -> ((ITooltip)tooltip1).add(arg_0));
    }

    public boolean enabledByDefault() {
        return false;
    }
}

