/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.gui;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class ScrollingStringWidget
extends StringWidget {
    public ScrollingStringWidget(int x, int y, int width, int height, Component component, Font font) {
        super(x, y, width, height, component, font);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ScrollingStringWidget.renderLeftAlignedScrollingString(guiGraphics, this.getFont(), this.getMessage(), this.getX(), this.getWidth(), this.getY(), this.getColor());
        if (this.isMouseOver(mouseX, mouseY) && this.getTooltip() != null) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.getTooltip().toCharSequence(Minecraft.getInstance()), mouseX, mouseY);
        }
    }

    private static void renderLeftAlignedScrollingString(GuiGraphics graphics, Font font, Component text, int minX, int width, int y, int color) {
        int messageWidth = font.width((FormattedText)text);
        if (messageWidth > width) {
            int overflowWidth = messageWidth - width;
            double d = (double)Util.getMillis() / 1000.0;
            double e = Math.max((double)overflowWidth * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.lerp((double)f, (double)0.0, (double)overflowWidth);
            Objects.requireNonNull(font);
            graphics.enableScissor(minX, y, minX + width, y + 9);
            graphics.drawString(font, text, minX - (int)g, y, color);
            graphics.disableScissor();
        } else {
            graphics.drawString(font, text, minX, y, color);
        }
    }
}

