/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import io.github.jamalam360.jamlib.client.config.gui.SelectionListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SelectionList
extends ContainerObjectSelectionList<SelectionListEntry> {
    public SelectionList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
        this.centerListVertically = false;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        SelectionListEntry hovered = this.getHoveredEntry(mouseX, mouseY);
        if (hovered != null && hovered.getTooltip() != null) {
            graphics.renderTooltip(Minecraft.getInstance().font, hovered.getTooltip(), mouseX, mouseY);
        }
    }

    @Nullable
    private SelectionListEntry getHoveredEntry(int mouseX, int mouseY) {
        SelectionListEntry entry = (SelectionListEntry)this.getEntryAtPosition(mouseX, mouseY);
        if (entry == null) {
            return null;
        }
        boolean anyWidgetsHovered = false;
        for (GuiEventListener guiEventListener : entry.children()) {
            if (!(guiEventListener instanceof AbstractWidget) || !guiEventListener.isMouseOver((double)mouseX, (double)mouseY)) continue;
            anyWidgetsHovered = true;
            break;
        }
        return anyWidgetsHovered ? null : entry;
    }

    protected int getScrollbarPosition() {
        return this.width - 7;
    }

    public int getRowWidth() {
        return 1000;
    }
}

