/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.search.Query;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RegexTagQuery
extends Query {
    private final Set<Object> valid;

    public RegexTagQuery(String name) {
        Pattern p = null;
        try {
            p = Pattern.compile(name, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (p == null) {
            this.valid = Set.of();
        } else {
            Pattern pat = p;
            this.valid = Stream.concat(EmiPort.getItemRegistry().getTagNames().filter(t -> {
                if (EmiTags.hasTranslation(t) && pat.matcher(EmiTags.getTagName(t).getString().toLowerCase()).find()) {
                    return true;
                }
                return pat.matcher(t.location().toString()).find();
            }).map(t -> EmiPort.getItemRegistry().getTag(t)), EmiPort.getBlockRegistry().getTagNames().filter(t -> pat.matcher(t.location().toString()).find()).map(t -> EmiPort.getBlockRegistry().getTag(t))).flatMap(v -> v.stream()).collect(Collectors.toSet());
        }
    }

    @Override
    public boolean matches(EmiStack stack) {
        return this.valid.contains(stack.getKey());
    }
}

