/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.chess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.chess.ChessBoard;
import dev.emi.emi.chess.ChessEmiStack;
import dev.emi.emi.chess.ChessMove;
import dev.emi.emi.chess.ChessPiece;
import dev.emi.emi.chess.MoveGenerator;
import dev.emi.emi.chess.NetworkedMoveGenerator;
import dev.emi.emi.chess.PieceColor;
import dev.emi.emi.chess.PieceType;
import dev.emi.emi.chess.StandardMoveGenerator;
import dev.emi.emi.config.SidebarType;
import dev.emi.emi.network.EmiChessPacket;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.screen.EmiScreenManager;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class EmiChess {
    public static final List<EmiStack> SIDEBAR;
    private static final EmiChess chess;
    public UUID opponent = null;
    public UUID pending = null;
    public boolean started = false;
    public ChessBoard board = ChessBoard.setupBoard();
    public MoveGenerator generator = new StandardMoveGenerator(PieceColor.BLACK);
    public PieceColor turn = PieceColor.WHITE;
    public int lastChecked = -1;
    public IntSet targets = new IntOpenHashSet();
    public int promotionStart = -1;
    public int pendingPromotion = -1;

    public boolean isTarget(int position) {
        EmiIngredient emiIngredient = EmiScreenManager.draggedStack;
        if (emiIngredient instanceof ChessEmiStack) {
            ChessEmiStack c = (ChessEmiStack)emiIngredient;
            if (c.position != this.lastChecked) {
                this.lastChecked = c.position;
                this.targets.clear();
                for (ChessMove move : this.board.getLegal(this.board.getMoves(this.lastChecked))) {
                    this.targets.add(move.end());
                }
            }
            return this.targets.contains(position);
        }
        return false;
    }

    public boolean isPlayerTurn() {
        return this.turn != this.generator.color;
    }

    public void update() {
        if (!this.isPlayerTurn() && this.generator.determinedMove()) {
            ChessMove move = this.generator.getMove();
            if (this.board.getLegal(this.board.getAllMoves(this.turn)).contains(move)) {
                this.doMove(this.generator.getMove());
            }
        }
    }

    public void doMove(ChessMove move) {
        EmiChess.getBoard().move(move);
        PieceColor op = this.turn.opposite();
        if (this.isPlayerTurn()) {
            this.generator.ponderMove(this.board.copy());
            MoveGenerator moveGenerator = this.generator;
            if (moveGenerator instanceof NetworkedMoveGenerator) {
                NetworkedMoveGenerator nmg = (NetworkedMoveGenerator)moveGenerator;
                EmiChess.sendNetwork(this.opponent, move.type(), move.start(), move.end());
            }
        }
        this.turn = op;
    }

    public static EmiChess get() {
        return chess;
    }

    public static ChessBoard getBoard() {
        return EmiChess.chess.board;
    }

    public static void restart() {
        EmiChess chess = EmiChess.get();
        chess.pending = null;
        chess.turn = PieceColor.WHITE;
        chess.board = ChessBoard.setupBoard();
        chess.started = false;
        chess.generator = new StandardMoveGenerator(PieceColor.BLACK);
    }

    public static void interact(EmiIngredient hovered, int button) {
        if (hovered instanceof ChessEmiStack) {
            ChessEmiStack c = (ChessEmiStack)hovered;
            int position = c.position;
            EmiChess chess = EmiChess.get();
            ChessPiece piece = chess.board.get(position);
            if (chess.started || piece == null || piece.type() != PieceType.KING || piece.color() == PieceColor.BLACK) {
                // empty if block
            }
            if (piece != null && piece.type() == PieceType.KING && button == 1) {
                if (piece.color() == PieceColor.WHITE || chess.pending != null) {
                    MoveGenerator moveGenerator = chess.generator;
                    if (moveGenerator instanceof NetworkedMoveGenerator) {
                        NetworkedMoveGenerator nmg = (NetworkedMoveGenerator)moveGenerator;
                        EmiChess.sendNetwork(chess.opponent, -3, 0, 0);
                    }
                    EmiChess.restart();
                }
            } else {
                int dir;
                int pending = chess.pendingPromotion;
                int n = dir = position > 31 ? -8 : 8;
                if (pending != -1) {
                    if (position == pending) {
                        chess.doMove(new ChessMove(chess.promotionStart, chess.pendingPromotion, 3));
                    } else if (position == pending + dir) {
                        chess.doMove(new ChessMove(chess.promotionStart, chess.pendingPromotion, 4));
                    } else if (position == pending + dir * 2) {
                        chess.doMove(new ChessMove(chess.promotionStart, chess.pendingPromotion, 5));
                    } else if (position == pending + dir * 3) {
                        chess.doMove(new ChessMove(chess.promotionStart, chess.pendingPromotion, 6));
                    }
                    chess.pendingPromotion = -1;
                }
            }
        }
    }

    public static void drop(EmiIngredient dragged, EmiIngredient hovered) {
        if (dragged instanceof ChessEmiStack) {
            ChessEmiStack cDragged = (ChessEmiStack)dragged;
            if (hovered instanceof ChessEmiStack) {
                ChessEmiStack cHovered = (ChessEmiStack)hovered;
                EmiChess chess = EmiChess.get();
                ChessPiece piece = EmiChess.get().board.get(cDragged.position);
                ChessPiece end = EmiChess.get().board.get(cHovered.position);
                if (!chess.started && end != null && end.type() == PieceType.KING && end.color() == PieceColor.BLACK) {
                    if (piece.color() == PieceColor.BLACK) {
                        if (piece.type() == PieceType.PAWN) {
                            EmiChess.invitePlayer();
                        }
                    } else if (piece.type() == PieceType.KING && chess.pending != null) {
                        chess.opponent = chess.pending;
                        chess.pending = null;
                        EmiChess.restart();
                        EmiChess.sendNetwork(chess.opponent, -2, 0, 0);
                        chess.generator = new NetworkedMoveGenerator(PieceColor.WHITE);
                    }
                }
                if (piece != null && piece.color() == chess.turn && chess.isPlayerTurn()) {
                    EmiChess.move(cDragged.position, cHovered.position);
                }
            }
        }
    }

    public static void move(int start, int end) {
        ChessBoard board = EmiChess.getBoard();
        for (ChessMove move : board.getLegal(board.getMoves(start))) {
            if (move.end() != end) continue;
            if (move.type() > 2) {
                EmiChess.get().promotionStart = move.start();
                EmiChess.get().pendingPromotion = move.end();
            } else {
                chess.doMove(move);
            }
            EmiChess.get().started = true;
            break;
        }
    }

    private static void invitePlayer() {
        Minecraft client = Minecraft.getInstance();
        String name = EmiScreenManager.search.getValue();
        for (AbstractClientPlayer player : client.level.players()) {
            if (!player.getName().getString().equals(name)) continue;
            EmiChess.get().opponent = player.getUUID();
            EmiChess.sendNetwork(player.getUUID(), -1, 0, 0);
        }
    }

    private static void sendNetwork(UUID uuid, int type, int start, int end) {
        EmiNetwork.sendToServer(new EmiChessPacket.C2S(uuid, (byte)type, (byte)start, (byte)end));
    }

    public static void receiveNetwork(UUID uuid, int type, int start, int end) {
        Minecraft client = Minecraft.getInstance();
        Player player = client.level.getPlayerByUUID(uuid);
        if (player == null) {
            return;
        }
        EmiChess chess = EmiChess.get();
        if (type == -1) {
            if (EmiScreenManager.hasSidebarAvailable(SidebarType.CHESS)) {
                chess.pending = uuid;
                client.player.displayClientMessage((Component)EmiPort.translatable("emi.chess.multiplayer.invited", player.getDisplayName()), false);
            } else {
                EmiChess.sendNetwork(uuid, -4, 0, 0);
            }
        } else if (type == -2) {
            if (chess.started) {
                EmiChess.sendNetwork(uuid, -3, 0, 0);
            } else if (uuid.equals(chess.opponent)) {
                client.player.displayClientMessage((Component)EmiPort.translatable("emi.chess.multiplayer.accepted", player.getDisplayName()), false);
                chess.generator = new NetworkedMoveGenerator(PieceColor.BLACK);
            }
        } else if (type == -3) {
            if (uuid.equals(chess.opponent)) {
                client.player.displayClientMessage((Component)EmiPort.translatable("emi.chess.multiplayer.cancelled", player.getDisplayName()), false);
                EmiChess.restart();
            }
        } else if (type == -4) {
            if (uuid.equals(chess.opponent)) {
                client.player.displayClientMessage((Component)EmiPort.translatable("emi.chess.multiplayer.unavailable", player.getDisplayName()), false);
            }
        } else {
            MoveGenerator moveGenerator = chess.generator;
            if (moveGenerator instanceof NetworkedMoveGenerator) {
                NetworkedMoveGenerator nmg = (NetworkedMoveGenerator)moveGenerator;
                if (chess.opponent.equals(uuid)) {
                    ChessMove desired = ChessMove.of(start, end, type);
                    if (chess.turn == chess.generator.color) {
                        ChessBoard board = EmiChess.getBoard();
                        for (ChessMove move : board.getLegal(board.getMoves(start))) {
                            if (!move.equals(desired)) continue;
                            nmg.move = desired;
                            return;
                        }
                    }
                }
            }
        }
    }

    static {
        chess = new EmiChess();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 64; ++i) {
            list.add(new ChessEmiStack(i));
        }
        SIDEBAR = ImmutableList.copyOf((Collection)list);
    }
}

