/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me;

import com.ibm.asyncutil.util.Combinators;
import com.ishland.c2me.PreLaunchHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="c2me")
public class C2MEMod {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME");

    public C2MEMod(IEventBus eventBus) {
        PreLaunchHandler.onPreLaunch();
        if (Boolean.getBoolean("com.ishland.c2me.runCompressionBenchmark")) {
            LOGGER.info("Benchmarking chunk stream speed");
            LOGGER.info("Warming up");
            for (int i = 0; i < 3; ++i) {
                this.runBenchmark("GZIP", RegionFileVersion.VERSION_GZIP, true);
                this.runBenchmark("DEFLATE", RegionFileVersion.VERSION_DEFLATE, true);
                this.runBenchmark("UNCOMPRESSED", RegionFileVersion.VERSION_NONE, true);
            }
            this.runBenchmark("GZIP", RegionFileVersion.VERSION_GZIP, false);
            this.runBenchmark("DEFLATE", RegionFileVersion.VERSION_DEFLATE, false);
            this.runBenchmark("UNCOMPRESSED", RegionFileVersion.VERSION_NONE, false);
        }
        if (Boolean.getBoolean("com.ishland.c2me.runConsistencyTest")) {
            this.consistencyTest();
        }
    }

    private void runBenchmark(String name, RegionFileVersion version, boolean suppressLog) {
        try {
            DecimalFormat decimalFormat = new DecimalFormat("0.###");
            if (!suppressLog) {
                LOGGER.info("Generating 128MB random data");
            }
            byte[] bytes = new byte[0x8000000];
            new Random().nextBytes(bytes);
            if (!suppressLog) {
                LOGGER.info("Starting benchmark for {}", (Object)name);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStream wrappedOutputStream = version.wrap((OutputStream)outputStream);
            long startTime = System.nanoTime();
            wrappedOutputStream.write(bytes);
            wrappedOutputStream.close();
            long endTime = System.nanoTime();
            if (!suppressLog) {
                LOGGER.info("{} write speed: {} MB/s ({} MB/s compressed)", new Object[]{name, decimalFormat.format((double)bytes.length / 1024.0 / 1024.0 / ((double)(endTime - startTime) / 1.0E9)), decimalFormat.format((double)outputStream.size() / 1024.0 / 1024.0 / ((double)(endTime - startTime) / 1.0E9))});
            }
            if (!suppressLog) {
                LOGGER.info("{} compression ratio: {} %", (Object)name, (Object)decimalFormat.format((double)outputStream.size() / (double)bytes.length * 100.0));
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            InputStream wrappedInputStream = version.wrap((InputStream)inputStream);
            long startTime2 = System.nanoTime();
            byte[] readAllBytes = wrappedInputStream.readAllBytes();
            wrappedInputStream.close();
            long endTime2 = System.nanoTime();
            if (!suppressLog) {
                LOGGER.info("{} read speed: {} MB/s ({} MB/s compressed)", new Object[]{name, decimalFormat.format((double)readAllBytes.length / 1024.0 / 1024.0 / ((double)(endTime2 - startTime2) / 1.0E9)), decimalFormat.format((double)outputStream.size() / 1024.0 / 1024.0 / ((double)(endTime2 - startTime2) / 1.0E9))});
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void consistencyTest() {
        int taskSize = 512;
        AtomicIntegerArray array = new AtomicIntegerArray(taskSize);
        List<CompletableFuture> futures = IntStream.range(0, taskSize).mapToObj(value -> CompletableFuture.supplyAsync(() -> {
            WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new SingleThreadedRandomSource(System.nanoTime()));
            chunkRandom.consumeCount(4096);
            int i = chunkRandom.nextInt();
            array.set(value, i);
            return i;
        })).toList();
        List join = (List)Combinators.collect(futures, Collectors.toList()).toCompletableFuture().join();
        for (int i = 0; i < taskSize; ++i) {
            if (array.get(i) == ((Integer)join.get(i)).intValue()) continue;
            throw new IllegalArgumentException("Mismatch at index " + i);
        }
    }
}

