/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.item;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.client.DataModelItemStackRenderer;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class DataModelItem
extends Item
implements ITabFiller {
    public DataModelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        DataModelInstance cModel = new DataModelInstance(stack, 0);
        if (!cModel.isValid()) {
            list.add((Component)Component.translatable((String)"Error: %s", (Object[])new Object[]{Component.literal((String)"Broke_AF").withStyle(new ChatFormatting[]{ChatFormatting.OBFUSCATED, ChatFormatting.GRAY})}));
            return;
        }
        int data = DataModelItem.getData(stack);
        ModelTier tier = ModelTierRegistry.getByData(cModel.getModel(), data);
        list.add((Component)Component.translatable((String)"hostilenetworks.info.tier", (Object[])new Object[]{tier.getComponent()}));
        int dProg = data - cModel.getTierData();
        int dMax = cModel.getNextTierData() - cModel.getTierData();
        if (!tier.isMax()) {
            list.add((Component)Component.translatable((String)"hostilenetworks.info.data", (Object[])new Object[]{Component.translatable((String)"hostilenetworks.info.dprog", (Object[])new Object[]{dProg, dMax}).withStyle(ChatFormatting.GRAY)}));
            int dataPerKill = cModel.getDataPerKill();
            if (dataPerKill == 0) {
                MutableComponent c1 = Component.literal((String)"000 ").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.OBFUSCATED});
                list.add((Component)Component.translatable((String)"hostilenetworks.info.dpk", (Object[])new Object[]{c1}).append((Component)Component.translatable((String)"hostilenetworks.info.disabled").withStyle(ChatFormatting.RED)));
            } else {
                list.add((Component)Component.translatable((String)"hostilenetworks.info.dpk", (Object[])new Object[]{Component.literal((String)("" + cModel.getDataPerKill())).withStyle(ChatFormatting.GRAY)}));
            }
        }
        list.add((Component)Component.translatable((String)"hostilenetworks.info.sim_cost", (Object[])new Object[]{Component.translatable((String)"hostilenetworks.info.rft", (Object[])new Object[]{cModel.getModel().simCost()}).withStyle(ChatFormatting.GRAY)}));
        List<EntityType<?>> subtypes = cModel.getModel().variants();
        if (!subtypes.isEmpty()) {
            list.add((Component)Component.translatable((String)"hostilenetworks.info.subtypes"));
            for (EntityType<?> t : subtypes) {
                list.add((Component)Component.translatable((String)"hostilenetworks.info.sub_list", (Object[])new Object[]{t.getDescription()}).withStyle(Style.EMPTY.withColor(65472)));
            }
        }
    }

    public void fillItemCategory(CreativeModeTab tab, BuildCreativeModeTabContentsEvent event) {
        DataModelRegistry.INSTANCE.getKeys().stream().sorted().map(arg_0 -> ((DataModelRegistry)DataModelRegistry.INSTANCE).holder(arg_0)).forEach(holder -> {
            ItemStack s = new ItemStack((ItemLike)this);
            DataModelItem.setStoredModel(s, (DynamicHolder<DataModel>)holder);
            event.accept(s);
        });
    }

    public Component getName(ItemStack pStack) {
        DynamicHolder<DataModel> model = DataModelItem.getStoredModel(pStack);
        MutableComponent modelName = !model.isBound() ? Component.literal((String)"BROKEN").withStyle(ChatFormatting.OBFUSCATED) : ((DataModel)model.get()).name().plainCopy();
        return Component.translatable((String)this.getDescriptionId(pStack), (Object[])new Object[]{modelName});
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            DataModelItemStackRenderer dmisr = new DataModelItemStackRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.dmisr;
            }
        });
    }

    public static DynamicHolder<DataModel> getStoredModel(ItemStack stack) {
        return (DynamicHolder)stack.getOrDefault(Hostile.Components.DATA_MODEL, (Object)DataModelRegistry.INSTANCE.emptyHolder());
    }

    public static void setStoredModel(ItemStack stack, DataModel model) {
        DataModelItem.setStoredModel(stack, (DynamicHolder<DataModel>)DataModelRegistry.INSTANCE.holder(model));
    }

    public static void setStoredModel(ItemStack stack, DynamicHolder<DataModel> model) {
        stack.set(Hostile.Components.DATA_MODEL, model);
    }

    public static int getData(ItemStack stack) {
        return (Integer)stack.getOrDefault(Hostile.Components.DATA, (Object)0);
    }

    public static void setData(ItemStack stack, int data) {
        stack.set(Hostile.Components.DATA, (Object)data);
    }

    public static int getIters(ItemStack stack) {
        return (Integer)stack.getOrDefault(Hostile.Components.ITERATIONS, (Object)0);
    }

    public static void setIters(ItemStack stack, int iterations) {
        stack.set(Hostile.Components.ITERATIONS, (Object)iterations);
    }

    public static boolean matchesModelInput(ItemStack model, ItemStack stack) {
        DynamicHolder<DataModel> dModel = DataModelItem.getStoredModel(model);
        if (!dModel.isBound()) {
            return false;
        }
        Ingredient input = ((DataModel)dModel.get()).input();
        return input.test(stack);
    }
}

