/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.icon.EntityImageIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class EntityIconLoader
extends SimplePreparableReloadListener<Map<EntityType<?>, EntityIconSettings>> {
    public static final Icon NORMAL = Icon.getIcon("ftblibrary:textures/faces/normal.png");
    public static final Icon HOSTILE = Icon.getIcon("ftblibrary:textures/faces/hostile.png");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<EntityType<?>, Map<ResourceLocation, Icon>> ICON_CACHE = new HashMap();
    private static final Map<EntityType<?>, EntityIconSettings> ENTITY_SETTINGS = new HashMap();
    private static final Set<EntityType<?>> DYNAMIC_JSON_TEXTURES = new HashSet();

    protected Map<EntityType<?>, EntityIconSettings> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = new HashMap();
        DYNAMIC_JSON_TEXTURES.clear();
        for (Map.Entry entry : RegistrarManager.get((String)"ftblibrary").get(Registries.ENTITY_TYPE).entrySet()) {
            Optional resource;
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            EntityType entityType = (EntityType)entry.getValue();
            String basePath = EntityIconLoader.getBasePath(id);
            ResourceLocation invisible = FTBLibrary.rl(basePath + ".invisible");
            EntityIconSettings entityIconSettings = null;
            if (resourceManager.getResource(invisible).isPresent()) {
                LOGGER.error("Entity {} is using legacy invisible texture, please update it to use the new system!", (Object)id);
                entityIconSettings = EntityIconSettings.OLD_HIDDEN;
            }
            if ((resource = resourceManager.getResource(FTBLibrary.rl(basePath + ".json"))).isPresent()) {
                entityIconSettings = this.loadEntitySetting(id, (Resource)resource.get());
                DYNAMIC_JSON_TEXTURES.add(entityType);
            } else {
                ResourceLocation imgLoc = FTBLibrary.rl(basePath + ".png");
                if (resourceManager.getResource(imgLoc).isPresent()) {
                    entityIconSettings = EntityIconSettings.forImage(imgLoc);
                }
            }
            if (entityIconSettings == null && entityType.getCategory() != MobCategory.MISC) {
                if (ModUtils.isDevMode()) {
                    LOGGER.error("Missing entity icon settings for {}", (Object)id);
                }
                entityIconSettings = EntityIconSettings.legacy();
            }
            map.put(entityType, entityIconSettings);
        }
        return map;
    }

    protected void apply(Map<EntityType<?>, EntityIconSettings> entityIconDataMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        ICON_CACHE.clear();
        ENTITY_SETTINGS.clear();
        ENTITY_SETTINGS.putAll(entityIconDataMap);
        FTBLibrary.LOGGER.debug("loaded {} entity face icons ({} using dynamic json textures)", (Object)entityIconDataMap.size(), (Object)DYNAMIC_JSON_TEXTURES.size());
    }

    public static boolean isDynamicTexture(EntityType<?> type) {
        return DYNAMIC_JSON_TEXTURES.contains(type);
    }

    private static String getBasePath(ResourceLocation id) {
        return "textures/faces/" + id.getNamespace() + "/" + id.getPath();
    }

    private EntityIconSettings loadEntitySetting(ResourceLocation id, Resource resource) {
        try {
            JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)resource.openAsReader(), JsonElement.class);
            DataResult settings = EntityIconSettings.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
            return (EntityIconSettings)settings.getOrThrow();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load entity icon settings for {}", (Object)id, (Object)e);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Failed to parse entity icon settings for {}", (Object)id, (Object)e);
        }
        return null;
    }

    private static Optional<Icon> getIconCache(Entity entity) {
        return EntityIconLoader.getSettings(entity.getType()).map(settings -> settings.useMobTexture ? EntityIconLoader.getOrCreateIcon(entity.getType(), Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(entity).getTextureLocation(entity), settings) : (Icon)settings.texture.map(resourceLocation -> EntityIconLoader.getOrCreateIcon(entity.getType(), resourceLocation, settings)).orElse(null));
    }

    public static Optional<EntityIconSettings> getSettings(EntityType<?> entityType) {
        return Optional.ofNullable(ENTITY_SETTINGS.get(entityType));
    }

    private static Icon getOrCreateIcon(EntityType<?> entityType, ResourceLocation texture, EntityIconSettings settings) {
        return ICON_CACHE.computeIfAbsent(entityType, i -> new HashMap()).computeIfAbsent(texture, t -> new EntityImageIcon((ResourceLocation)t, settings.mainSlice.orElse(null), settings.children, settings.defaultImageSize.orElse(null)));
    }

    public static Icon getIcon(Entity entity) {
        return EntityIconLoader.getIconCache(entity).orElseGet(() -> entity instanceof Enemy ? HOSTILE : NORMAL);
    }

    public static Icon getIcon(EntityType<?> entityType) {
        Entity entity = entityType.create((Level)Minecraft.getInstance().level);
        return entity == null ? NORMAL : EntityIconLoader.getIcon(entity);
    }

    public record EntityIconSettings(boolean useMobTexture, Optional<ResourceLocation> texture, Optional<EntityImageIcon.Slice> mainSlice, List<EntityImageIcon.ChildIconData> children, WidthHeight widthHeight, Optional<WidthHeight> defaultImageSize, double scale, boolean defaultEnabled) {
        private static final EntityIconSettings OLD_HIDDEN = new EntityIconSettings(false, Optional.empty(), Optional.empty(), List.of(), WidthHeight.DEFAULT, Optional.empty(), 1.0, true);
        public static final Codec<EntityIconSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("use_mob_texture", (Object)false).forGetter(s -> s.useMobTexture), (App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(s -> s.texture), (App)EntityImageIcon.Slice.CODEC.optionalFieldOf("slice").forGetter(entityIconData -> entityIconData.mainSlice), (App)EntityImageIcon.ChildIconData.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(entityIconData -> entityIconData.children), (App)WidthHeight.CODEC.optionalFieldOf("size", (Object)WidthHeight.DEFAULT).forGetter(s -> s.widthHeight), (App)WidthHeight.CODEC.optionalFieldOf("default_image_size").forGetter(s -> s.defaultImageSize), (App)Codec.DOUBLE.optionalFieldOf("scale", (Object)1.0).forGetter(s -> s.scale), (App)Codec.BOOL.optionalFieldOf("default_enabled", (Object)true).forGetter(s -> s.defaultEnabled)).apply((Applicative)builder, EntityIconSettings::new)).validate(settings -> settings.texture().isEmpty() && !settings.useMobTexture ? DataResult.error(() -> "Texture is required if use_mob_texture is false") : DataResult.success((Object)settings));

        public static EntityIconSettings forImage(ResourceLocation imgLoc) {
            return new EntityIconSettings(false, Optional.of(imgLoc), Optional.empty(), List.of(), WidthHeight.DEFAULT, Optional.empty(), 1.0, true);
        }

        public static EntityIconSettings legacy() {
            return OLD_HIDDEN;
        }
    }

    public record WidthHeight(int width, int height) {
        public static final WidthHeight DEFAULT = new WidthHeight(16, 16);
        public static final Codec<WidthHeight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(WidthHeight::width), (App)Codec.INT.fieldOf("height").forGetter(WidthHeight::height)).apply((Applicative)instance, WidthHeight::new));
    }
}

