/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.module.particle;

import it.hurts.octostudios.octolib.client.shake.ShakeSystem;
import it.hurts.octostudios.octolib.module.config.ConfigManager;
import it.hurts.octostudios.octolib.module.particle.RenderBuffer;
import it.hurts.octostudios.octolib.module.particle.RenderProvider;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.WeakHashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import org.apache.logging.log4j.util.Cast;

public class OctoRenderManager {
    static long lastTick = 0L;
    static Queue<RenderProvider<?, ?>> providers = new ArrayDeque();
    static WeakHashMap<RenderProvider<?, ?>, RenderBuffer<?, ?>> map = new WeakHashMap();

    public static void worldExit(LocalPlayer player) {
        map.clear();
        providers.clear();
        ConfigManager.reloadAll();
    }

    public static void clientTick(ClientLevel level) {
        long time = level.getGameTime();
        if (time == lastTick) {
            return;
        }
        lastTick = time;
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            Object buffer;
            RenderProvider p = (RenderProvider)iterator.next();
            if (!p.shouldRender((RenderBuffer)Cast.cast(buffer = OctoRenderManager.getOrCreateBuffer((RenderProvider)Cast.cast((Object)p))))) {
                map.remove(p);
                iterator.remove();
                continue;
            }
            if (time % (long)p.getUpdateFrequency() != 0L) continue;
            buffer.tick((RenderProvider)p);
        }
    }

    public static void clientRenderTick() {
        ShakeSystem.updateAll();
    }

    public static <B extends RenderBuffer<P, B>, P extends RenderProvider<P, B>> B getOrCreateBuffer(P provider) {
        if (map.containsKey(provider)) {
            return (B)map.get(provider);
        }
        B buffer = provider.createBuffer();
        map.put(provider, (RenderBuffer<?, ?>)buffer);
        return buffer;
    }

    public static <B extends RenderBuffer<P, B>, P extends RenderProvider<P, B>> void registerProvider(P provider) {
        if (map.containsKey(provider)) {
            return;
        }
        providers.add(provider);
        map.put(provider, (RenderBuffer<?, ?>)provider.createBuffer());
    }

    public static Queue<RenderProvider<?, ?>> getProviders() {
        return providers;
    }
}

