/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.animation;

import it.hurts.octostudios.octolib.client.animation.Tween;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;

public class TweenSystem {
    private static final List<Tween> TWEENS = new ArrayList<Tween>();
    private static final Queue<Tween> PENDING = new ConcurrentLinkedQueue<Tween>();
    private static boolean running = false;

    public static void init() {
        if (running) {
            return;
        }
        running = true;
        Thread tweenThread = new Thread(() -> {
            while (running) {
                Tween tween;
                if (TWEENS.isEmpty() && PENDING.isEmpty()) {
                    LockSupport.parkNanos(2000000L);
                    continue;
                }
                while ((tween = PENDING.poll()) != null) {
                    if (TWEENS.contains(tween)) continue;
                    TWEENS.add(tween);
                }
                TweenSystem.updateAll();
                LockSupport.parkNanos(2000000L);
            }
        }, "Tween thread");
        tweenThread.setDaemon(true);
        tweenThread.start();
    }

    protected static void addTween(Tween tween) {
        PENDING.add(tween);
    }

    public static void updateAll() {
        ArrayList toRemove = new ArrayList();
        TWEENS.forEach(tween -> {
            if (!tween.step()) {
                tween.clear();
                toRemove.add(tween);
            }
        });
        TWEENS.removeAll(toRemove);
    }

    public static class ServerThreadExecutor {
        private static final Queue<Runnable> serverQueue = new ConcurrentLinkedQueue<Runnable>();

        public static void runOnServerThread(Runnable task) {
            serverQueue.add(task);
        }

        public static void executeAll() {
            Runnable task;
            while ((task = serverQueue.poll()) != null) {
                task.run();
            }
        }
    }

    public static class RenderThreadExecutor {
        private static final Queue<Runnable> renderQueue = new ConcurrentLinkedQueue<Runnable>();

        public static void runOnRenderThread(Runnable task) {
            renderQueue.add(task);
        }

        public static void executeAll() {
            Runnable task;
            while ((task = renderQueue.poll()) != null) {
                task.run();
            }
        }
    }
}

