/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient.capability;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.common.extensions.ILevelExtension;

public interface ICapabilityGetter<C> {
    @Nullable
    public <T> T getCapability(BaseCapability<T, C> var1, @Nullable C var2);

    public boolean canHandleCapabilityType(BaseCapability<?, ?> var1);

    public static <C> ICapabilityGetter<C> forBlock(final ILevelExtension level, final BlockPos pos, final @Nullable BlockState state, final @Nullable BlockEntity blockEntity) {
        return new ICapabilityGetter<C>(){

            @Override
            @Nullable
            public <T> T getCapability(BaseCapability<T, C> capability, @Nullable C context) {
                return (T)level.getCapability((BlockCapability)capability, pos, state, blockEntity, capability.contextClass() == Void.TYPE ? null : context);
            }

            @Override
            public boolean canHandleCapabilityType(BaseCapability<?, ?> capability) {
                return capability instanceof BlockCapability;
            }
        };
    }

    public static <C> ICapabilityGetter<C> forBlockEntity(final BlockEntity blockEntity) {
        return new ICapabilityGetter<C>(){

            @Override
            @Nullable
            public <T> T getCapability(BaseCapability<T, C> capability, @Nullable C context) {
                return (T)blockEntity.getLevel().getCapability((BlockCapability)capability, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, capability.contextClass() == Void.TYPE ? null : context);
            }

            @Override
            public boolean canHandleCapabilityType(BaseCapability<?, ?> capability) {
                return capability instanceof BlockCapability;
            }
        };
    }

    public static <C> ICapabilityGetter<C> forEntity(final Entity entity) {
        return new ICapabilityGetter<C>(){

            @Override
            @Nullable
            public <T> T getCapability(BaseCapability<T, C> capability, @Nullable C context) {
                return (T)entity.getCapability((EntityCapability)capability, capability.contextClass() == Void.TYPE ? null : context);
            }

            @Override
            public boolean canHandleCapabilityType(BaseCapability<?, ?> capability) {
                return capability instanceof EntityCapability;
            }
        };
    }

    public static <C> ICapabilityGetter<C> forItem(final ItemStack itemStack) {
        return new ICapabilityGetter<C>(){

            @Override
            @Nullable
            public <T> T getCapability(BaseCapability<T, C> capability, @Nullable C context) {
                return (T)itemStack.getCapability((ItemCapability)capability, capability.contextClass() == Void.TYPE ? null : context);
            }

            @Override
            public boolean canHandleCapabilityType(BaseCapability<?, ?> capability) {
                return capability instanceof ItemCapability;
            }
        };
    }
}

