/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.mixin;

import dev.foxgirl.damagenumbers.DamageNumbers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity {
    @Unique
    private float previousHealth = 0.0f;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void injected$tick(CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        Level world = entity.level();
        if (world == null || !world.isClientSide()) {
            return;
        }
        float oldHealth = this.previousHealth;
        float newHealth = entity.getHealth();
        if (oldHealth != newHealth) {
            this.previousHealth = newHealth;
            DamageNumbers.getHandler().onEntityHealthChange(entity, oldHealth, newHealth);
        }
    }
}

