/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.foxgirl.damagenumbers.client.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public final class TextParticle
extends Particle {
    private String text;

    public TextParticle(ClientLevel world, Vec3 pos, Vec3 velocity) {
        super(world, pos.x, pos.y, pos.z, velocity.x, velocity.y, velocity.z);
        this.friction = 0.99f;
        this.gravity = 0.75f;
        this.lifetime = 32;
    }

    public void setText(@NotNull String text) {
        this.text = text;
    }

    public void setColor(@NotNull Color color) {
        this.rCol = color.r();
        this.gCol = color.g();
        this.bCol = color.b();
        this.alpha = color.a();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 cameraPos = camera.getPosition();
        float particleX = (float)(this.xo + (this.x - this.xo) * (double)tickDelta - cameraPos.x);
        float particleY = (float)(this.yo + (this.y - this.yo) * (double)tickDelta - cameraPos.y);
        float particleZ = (float)(this.zo + (this.z - this.zo) * (double)tickDelta - cameraPos.z);
        Matrix4f matrix = new Matrix4f();
        matrix = matrix.translation(particleX, particleY, particleZ);
        matrix = matrix.rotate((Quaternionfc)camera.rotation());
        matrix = matrix.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix = matrix.scale(-0.025f, -0.025f, -0.025f);
        Minecraft client = Minecraft.getInstance();
        Font textRenderer = client.font;
        MultiBufferSource.BufferSource vertexConsumers = client.renderBuffers().bufferSource();
        float textX = (float)textRenderer.width(this.text) / -2.0f;
        float textY = 0.0f;
        int textColor = new Color(this.rCol, this.gCol, this.bCol, this.alpha).getValue();
        textRenderer.drawInBatch(this.text, textX, textY, textColor, false, matrix, (MultiBufferSource)vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        vertexConsumers.endBatch();
    }
}

