/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.client;

import dev.foxgirl.damagenumbers.DamageNumbers;
import dev.foxgirl.damagenumbers.client.Color;
import dev.foxgirl.damagenumbers.client.Config;
import dev.foxgirl.damagenumbers.client.ConfigScreenFactory;
import dev.foxgirl.damagenumbers.client.DamageNumbersHandler;
import dev.foxgirl.damagenumbers.client.TextParticle;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class DamageNumbersImpl
implements DamageNumbersHandler,
Config.PathProvider {
    @NotNull
    public final Config config = new Config();
    @NotNull
    public final Config configDefault = new Config();
    @NotNull
    public final Path configDirPath;
    private final Deque<TextParticle> particles = new ArrayDeque<TextParticle>();

    @Override
    @NotNull
    public Path getConfigFilePath() {
        return this.configDirPath.resolve("damagenumbers.json");
    }

    @Override
    @NotNull
    public Path getConfigTempPath() {
        return this.configDirPath.resolve("damagenumbers.json.tmp");
    }

    public DamageNumbersImpl(@NotNull Path configDir) {
        this.configDirPath = configDir;
        this.config.readConfig(this);
    }

    @Override
    @NotNull
    public Screen createConfigScreen(@NotNull Screen parent) {
        try {
            ConfigScreenFactory factory = (ConfigScreenFactory)Class.forName("dev.foxgirl.damagenumbers.client.ConfigScreenFactoryImpl").getConstructor(Config.class, Config.class, Config.PathProvider.class).newInstance(this.config, this.configDefault, this);
            return factory.createConfigScreen(parent);
        }
        catch (NoClassDefFoundError cause) {
            DamageNumbers.LOGGER.error("Failed to create config screen due to missing class", (Throwable)cause);
        }
        catch (ReflectiveOperationException cause) {
            DamageNumbers.LOGGER.error("Failed to create config screen due to reflection error", (Throwable)cause);
        }
        return new AlertScreen(() -> Minecraft.getInstance().setScreen(parent), Component.nullToEmpty((String)"Config screen unavailable"), Component.nullToEmpty((String)"YACL3 (Yet Another Config Library 3) may not be installed.\nPlease install a supported version to use the Damage Numbers config screen."));
    }

    @Override
    public void onEntityHealthChange(@NotNull LivingEntity entity, float oldHealth, float newHealth) {
        int particleLimit;
        if (!this.config.isEnabled) {
            return;
        }
        float damage = oldHealth - newHealth;
        if (damage <= 0.0f) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (entity == client.player && !this.config.isPlayerDamageShown) {
            return;
        }
        ClientLevel world = client.level;
        if (world == null || world != entity.level()) {
            return;
        }
        if (entity.distanceToSqr((Entity)client.player) > 2304.0) {
            return;
        }
        switch ((ParticleStatus)client.options.particles().get()) {
            default: {
                throw new MatchException(null, null);
            }
            case ALL: {
                int n = 256;
                break;
            }
            case DECREASED: {
                int n = 64;
                break;
            }
            case MINIMAL: {
                int n = particleLimit = 16;
            }
        }
        while (this.particles.size() >= particleLimit) {
            TextParticle particle = this.particles.poll();
            if (particle == null) continue;
            particle.remove();
        }
        Vec3 particlePos = entity.position().add(0.0, (double)entity.getBbHeight() + 0.25, 0.0);
        Vec3 particleVelocity = entity.getDeltaMovement();
        Vec3 particleVelocityForward = entity.position();
        particleVelocityForward = particleVelocityForward.subtract(client.gameRenderer.getMainCamera().getPosition()).normalize();
        particleVelocityForward = particleVelocityForward.scale((double)entity.getBbWidth() * 10.0);
        particleVelocity = particleVelocity.subtract(particleVelocityForward.x, -20.0, particleVelocityForward.z);
        TextParticle particle = new TextParticle(world, particlePos, particleVelocity);
        String text = String.format("%.1f", Float.valueOf(damage));
        if (text.endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        particle.setText(text);
        if (damage >= 16.0f) {
            particle.setColor(this.config.colorLg);
        } else if (damage >= 8.0f) {
            particle.setColor(Color.lerp(this.config.colorMd, this.config.colorLg, (damage - 8.0f) / 8.0f));
        } else if (damage >= 2.0f) {
            particle.setColor(Color.lerp(this.config.colorSm, this.config.colorMd, (damage - 2.0f) / 6.0f));
        } else {
            particle.setColor(this.config.colorSm);
        }
        this.particles.add(particle);
        client.particleEngine.add((Particle)particle);
    }
}

