/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.network.s2c.FireResponse;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class BulletWeapon
extends Weapon {
    private final Random random = new Random();
    private ItemStack ammoStack = ItemStack.EMPTY;
    private int ammo;

    public BulletWeapon(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    protected float getBarrelLength() {
        return 1.0f;
    }

    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected int getBulletCount() {
        return 1;
    }

    @Override
    public void fire(Vector3f direction) {
        Vector4f position = this.getBarrelOffset();
        VehicleEntity entity = this.getEntity();
        position.mul((Matrix4fc)this.getMount().transform());
        position.mul((Matrix4fc)entity.getVehicleTransform());
        Vec3 speed = entity.getSpeedVector();
        float barrelLength = this.getBarrelLength();
        position.add(direction.x() * barrelLength, direction.y() * barrelLength, direction.z() * barrelLength, 0.0f);
        for (int i = 0; i < this.getBulletCount(); ++i) {
            Entity bullet = this.getBullet(position, direction);
            bullet.setDeltaMovement(bullet.getDeltaMovement().add(speed));
            entity.level().addFreshEntity(bullet);
        }
        direction.mul(0.25f);
        direction.add((float)speed.x, (float)speed.y, (float)speed.z);
        FireResponse fireMessage = new FireResponse(position, direction);
        for (ServerPlayer player : ((ServerLevel)entity.level()).players()) {
            NetworkHandler.sendToPlayer(fireMessage, player);
        }
        this.getEntity().playSound(this.getSound(), 1.0f, this.random.nextFloat() * 0.2f + 0.9f);
    }

    protected abstract Entity getBullet(Vector4f var1, Vector3f var2);

    public SoundEvent getSound() {
        return SoundEvents.CROSSBOW_SHOOT;
    }

    protected boolean spentAmmo(Map<String, Integer> ammunition, int amount) {
        VehicleEntity vehicleEntity;
        if (this.ammo < amount && (vehicleEntity = this.getEntity()) instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)vehicleEntity;
            for (int i = 0; i < vehicle.getInventory().getContainerSize(); ++i) {
                ItemStack stack = vehicle.getInventory().getItem(i);
                String key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
                if (!ammunition.containsKey(key)) continue;
                this.ammoStack = stack.copy();
                if (this.getEntity().isPilotCreative()) break;
                this.ammo += ammunition.get(key).intValue();
                stack.shrink(1);
                break;
            }
        }
        if (this.getEntity().isPilotCreative()) {
            return true;
        }
        if (this.ammo <= 0) {
            vehicleEntity = this.getEntity().getControllingPassenger();
            if (vehicleEntity instanceof Player) {
                Player player = (Player)vehicleEntity;
                player.displayClientMessage((Component)Component.translatable((String)"immersive_aircraft.out_of_ammo"), true);
            }
            return false;
        }
        this.ammo -= amount;
        return true;
    }

    public ItemStack getAmmoStack() {
        return this.ammoStack;
    }

    public int getAmmo() {
        return this.ammo;
    }
}

