/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.inventory;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import immersive_aircraft.entity.inventory.slots.FuelSlotDescription;
import immersive_aircraft.entity.inventory.slots.IngredientSlotDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.entity.inventory.slots.TypedSlotDescription;
import immersive_aircraft.entity.inventory.slots.UpgradeSlotDescription;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.util.Rect2iCommon;
import immersive_aircraft.util.Utils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.FireworkRocketItem;

public class VehicleInventoryDescription {
    int height = 0;
    int lastIndex = 0;
    int lastSyncIndex = 0;
    final List<Rect2iCommon> rectangles = new LinkedList<Rect2iCommon>();
    public static final Map<String, SlotDescription.SlotDescriptionFactory> SLOT_TYPES = new ConcurrentHashMap<String, SlotDescription.SlotDescriptionFactory>();
    public static final Map<String, SlotDescription.SlotDescriptionDecoder> SLOT_DECODER = new ConcurrentHashMap<String, SlotDescription.SlotDescriptionDecoder>();
    public static final String INVENTORY = VehicleInventoryDescription.registerSlotType("inventory", SlotDescription::new, SlotDescription::new);
    public static final String BOILER = VehicleInventoryDescription.registerSlotType("boiler", FuelSlotDescription::new, FuelSlotDescription::new);
    public static final String WEAPON = VehicleInventoryDescription.registerSlotType("weapon", (type, index, x, y, json) -> new TypedSlotDescription(type, index, x, y, json, WeaponItem.class, 1), (type, buffer) -> new TypedSlotDescription(type, buffer, WeaponItem.class));
    public static final String UPGRADE = VehicleInventoryDescription.registerSlotType("upgrade", UpgradeSlotDescription::new, UpgradeSlotDescription::new);
    public static final String BOOSTER = VehicleInventoryDescription.registerSlotType("booster", (type, index, x, y, json) -> new TypedSlotDescription(type, index, x, y, json, FireworkRocketItem.class, 64), (type, buffer) -> new TypedSlotDescription(type, buffer, FireworkRocketItem.class));
    public static final String BANNER = VehicleInventoryDescription.registerSlotType("banner", (type, index, x, y, json) -> new TypedSlotDescription(type, index, x, y, json, BannerItem.class, 1), (type, buffer) -> new TypedSlotDescription(type, buffer, BannerItem.class));
    public static final String DYE = VehicleInventoryDescription.registerSlotType("dye", (type, index, x, y, json) -> new TypedSlotDescription(type, index, x, y, json, DyeItem.class, 1), (type, buffer) -> new TypedSlotDescription(type, buffer, DyeItem.class));
    public static final String INGREDIENT = VehicleInventoryDescription.registerSlotType("ingredient", IngredientSlotDescription::new, IngredientSlotDescription::new);
    final HashMap<String, List<SlotDescription>> slotMap = new HashMap();
    final List<SlotDescription> slots = new LinkedList<SlotDescription>();

    public VehicleInventoryDescription() {
    }

    public VehicleInventoryDescription(RegistryFriendlyByteBuf buffer) {
        int slotCount = buffer.readInt();
        for (int i = 0; i < slotCount; ++i) {
            String type = buffer.readUtf();
            this.addSlot(SLOT_DECODER.get(type).decode(type, buffer));
        }
        int rectCount = buffer.readInt();
        for (int i = 0; i < rectCount; ++i) {
            this.addRectangle(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        this.build();
    }

    public VehicleInventoryDescription(JsonArray inventorySlots) {
        inventorySlots.forEach(jsonElement -> {
            boolean boxed;
            JsonObject slot = jsonElement.getAsJsonObject();
            int cols = Utils.getIntElement(slot, "cols", 1);
            int rows = Utils.getIntElement(slot, "rows", 1);
            String type = slot.get("type").getAsString();
            int x = slot.get("x").getAsInt();
            int y = slot.get("y").getAsInt();
            boolean bl = boxed = slot.has("boxed") && slot.getAsJsonPrimitive("boxed").getAsBoolean();
            if (!SLOT_TYPES.containsKey(type)) {
                throw new IllegalArgumentException("Unknown slot type: " + type);
            }
            this.addSlots(type, x, y, cols, rows, boxed, slot);
        });
        this.build();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.slots.size());
        for (SlotDescription slot : this.slots) {
            buffer.writeUtf(slot.type());
            slot.encode(buffer);
        }
        buffer.writeInt(this.rectangles.size());
        for (Rect2iCommon rectangle : this.rectangles) {
            buffer.writeInt(rectangle.getX());
            buffer.writeInt(rectangle.getY());
            buffer.writeInt(rectangle.getWidth());
            buffer.writeInt(rectangle.getHeight());
        }
    }

    public static String registerSlotType(String name, SlotDescription.SlotDescriptionFactory slotFactory, SlotDescription.SlotDescriptionDecoder slotDecoder) {
        SLOT_TYPES.put(name, slotFactory);
        SLOT_DECODER.put(name, slotDecoder);
        return name;
    }

    public int getInventorySize() {
        return this.slots.size();
    }

    public List<SlotDescription> getSlots() {
        return this.slots;
    }

    public List<SlotDescription> getSlots(String type) {
        return this.slotMap.computeIfAbsent(type, k -> new LinkedList());
    }

    public VehicleInventoryDescription addSlot(SlotDescription slotDescription) {
        this.getSlots(slotDescription.type()).add(slotDescription);
        this.slots.add(slotDescription);
        if (!slotDescription.type().equals("inventory")) {
            this.lastSyncIndex = slotDescription.index();
        }
        return this;
    }

    public VehicleInventoryDescription addSlots(String type, int x, int y, int cols, int rows, boolean boxed, JsonObject json) {
        if (boxed) {
            this.addRectangle(x - 8, y - 8, cols * 18 + 14, rows * 18 + 14);
        }
        for (int sx = 0; sx < cols; ++sx) {
            for (int sy = 0; sy < rows; ++sy) {
                this.addSlot(SLOT_TYPES.get(type).construct(type, this.lastIndex++, x + sx * 18, y + sy * 18, json));
            }
        }
        return this;
    }

    public VehicleInventoryDescription addRectangle(int x, int y, int w, int h) {
        this.rectangles.add(new Rect2iCommon(x, y, w, h));
        return this;
    }

    public VehicleInventoryDescription build() {
        for (SlotDescription slot : this.slots) {
            if (slot.x() < 0 || slot.x() >= 176) continue;
            this.height = Math.max(this.height, slot.y() + 18);
        }
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLastSyncIndex() {
        return this.lastSyncIndex;
    }

    public List<Rect2iCommon> getRectangles() {
        return this.rectangles;
    }
}

