/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.inventory;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.network.c2s.InventoryRequest;
import immersive_aircraft.network.s2c.InventoryUpdateMessage;
import immersive_aircraft.screen.VehicleScreenHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class SparseSimpleInventory
extends SimpleContainer {
    private final NonNullList<ItemStack> tracked;
    private boolean inventoryRequested = false;

    public SparseSimpleInventory(int size) {
        super(size);
        this.tracked = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public void fromTag(ListTag tag, HolderLookup.Provider levelRegistry) {
        int i;
        for (i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
        for (i = 0; i < tag.size(); ++i) {
            CompoundTag compoundTag = tag.getCompound(i);
            int j = compoundTag.getByte("Slot") & 0xFF;
            if (j >= this.getContainerSize()) continue;
            this.setItem(j, ItemStack.parse((HolderLookup.Provider)levelRegistry, (Tag)compoundTag).orElse(ItemStack.EMPTY));
        }
    }

    public ListTag createTag(HolderLookup.Provider levelRegistry) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            listTag.add((Object)itemStack.save(levelRegistry, (Tag)compoundTag));
        }
        return listTag;
    }

    public void tick(InventoryVehicleEntity entity) {
        if (entity.level().isClientSide) {
            if (!this.inventoryRequested) {
                NetworkHandler.sendToServer(new InventoryRequest(entity.getId()));
                this.inventoryRequested = true;
            }
        } else {
            ItemStack trackedStack;
            int lastSyncIndex = entity.getInventoryDescription().getLastSyncIndex();
            if (lastSyncIndex == 0) {
                return;
            }
            int index = entity.tickCount % lastSyncIndex;
            ItemStack stack = this.getItem(index);
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)(trackedStack = (ItemStack)this.tracked.get(index)))) {
                this.tracked.set(index, (Object)stack.copy());
                entity.level().players().forEach(p -> {
                    VehicleScreenHandler vehicleScreenHandler;
                    AbstractContainerMenu patt0$temp = p.containerMenu;
                    if (!(patt0$temp instanceof VehicleScreenHandler) || (vehicleScreenHandler = (VehicleScreenHandler)patt0$temp).getVehicle() != entity) {
                        NetworkHandler.sendToPlayer(new InventoryUpdateMessage(entity, index, stack), (ServerPlayer)p);
                    }
                });
            }
        }
    }
}

