/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.entity.EngineVehicle;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;

public class AttitudeIndicator
implements Indicator {
    public static final AttitudeIndicator INSTANCE = new AttitudeIndicator();
    private float yawRate = 0.0f;
    private float pitch = 0.0f;
    private float roll = 0.0f;

    @Override
    public void update(Minecraft client, EngineVehicle aircraft) {
        this.pitch = aircraft.getXRot();
        float yaw = aircraft.getYRot();
        this.yawRate = (yaw - aircraft.yRotO) * 20.0f;
        this.roll = aircraft.getRoll();
    }

    @Override
    public void drawDashboard(GuiGraphics context, Minecraft client, int baseX, int baseY, EngineVehicle aircraft, int color) {
    }

    @Override
    public void drawHUD(GuiGraphics context, Minecraft client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        Vec3 vecBase = new Vec3((double)(baseX - 1), (double)baseY, 0.0);
        float roll2 = (float)Math.toRadians(this.roll);
        IntStream.of(-90, -75, -60, -45, -30, -15, 0, 15, 30, 45, 60, 75, 90).forEach(value -> {
            int y = -((int)(Math.sin(Math.toRadians(value)) * 100.0));
            if (Math.abs(y -= (int)(Math.sin(Math.toRadians(this.pitch)) * 100.0)) > 55) {
                return;
            }
            int xn = (int)(this.yawRate / 20.0f);
            int x1 = value == 0 ? -40 : -32;
            int x2 = switch (value) {
                case -75, -45, -15, 15, 45, 75 -> -23;
                case -90, -60, -30, 0, 30, 60, 90 -> -12;
                default -> -12;
            };
            int x3 = -x2;
            int x4 = -x1;
            Vec3 v1 = new Vec3((double)(x1 - xn), (double)y, 0.0).zRot(roll2).scale((double)((float)width / 100.0f)).add(vecBase);
            Vec3 v2 = new Vec3((double)(x2 - xn), (double)y, 0.0).zRot(roll2).scale((double)((float)width / 100.0f)).add(vecBase);
            Vec3 v3 = new Vec3((double)(x3 - xn), (double)y, 0.0).zRot(roll2).scale((double)((float)width / 100.0f)).add(vecBase);
            Vec3 v4 = new Vec3((double)(x4 - xn), (double)y, 0.0).zRot(roll2).scale((double)((float)width / 100.0f)).add(vecBase);
            Vec3 v5 = new Vec3((double)(x1 - xn), (double)(y + 3), 0.0).zRot(roll2).scale((double)((float)width / 100.0f)).add(vecBase);
            Vec3 v6 = new Vec3((double)(x4 - xn), (double)(y + 3), 0.0).zRot(roll2).scale((double)((float)width / 100.0f)).add(vecBase);
            int[][] lgroup = new int[][]{{(int)v1.x, (int)v1.y, (int)v2.x, (int)v2.y}, {(int)v3.x, (int)v3.y, (int)v4.x, (int)v4.y}};
            int[][] lgroup2 = new int[][]{{(int)v1.x, (int)v1.y, (int)v5.x, (int)v5.y}, {(int)v4.x, (int)v4.y, (int)v6.x, (int)v6.y}};
            for (int[] l : lgroup) {
                if (!this.edgeCheck(edge, Math.abs(l[2] - l[0]) / 2, 2, (l[0] + l[2]) / 2, (l[1] + l[3]) / 2)) continue;
                OverlayRenderer.renderLine(context, l[0], l[1], l[2], l[3], color, value < 0);
            }
            if (value != 0) {
                for (int[] l : lgroup2) {
                    if (!this.edgeCheck(edge, 2, l[0], l[1])) continue;
                    OverlayRenderer.renderLine(context, l[0], l[1], l[2], l[3], color);
                }
                switch (Math.abs(value)) {
                    case 15: 
                    case 45: 
                    case 75: {
                        if (this.edgeCheck(edge, 2, (int)v2.x, (int)v2.y)) {
                            StringDrawer.drawString1(context, client, StringDrawer.toSuperScript(String.valueOf(Math.abs(value))), (int)v2.x, (int)v2.y, color, false);
                        }
                        if (!this.edgeCheck(edge, 2, (int)v3.x, (int)v3.y)) break;
                        StringDrawer.drawString3(context, client, StringDrawer.toSuperScript(String.valueOf(Math.abs(value))), (int)v3.x, (int)v3.y, color, false);
                    }
                }
            }
        });
    }

    @Override
    public void drawDials(GuiGraphics context, Minecraft client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorLt0);
        Vec3 vecBase = new Vec3((double)baseX, (double)baseY, 0.0);
        float roll2 = (float)Math.toRadians(this.roll);
        Vec3 v0 = new Vec3(0.0, 4.0, 0.0).scale((double)scale);
        Vec3 vd = new Vec3((double)((int)(this.yawRate / 20.0f)), (double)(-((int)(Math.sin(Math.toRadians(this.pitch)) * 40.0))), 0.0).scale((double)scale);
        int[] edge0 = new int[]{baseY - 27 * scale, baseY + 27 * scale, baseX - 27 * scale, baseX + 27 * scale};
        for (int i = 0; i < 10; ++i) {
            Vec3 v01 = v0.scale((double)i);
            Vec3 v02 = v0.scale((double)(i + 1)).add(0.0, (double)scale, 0.0);
            Vec3 v1 = v01.add(vd).zRot(roll2).add(vecBase);
            Vec3 v2 = v02.add(vd).zRot(roll2).add(vecBase);
            if (this.edgeCheck(edge0, 2 * scale, (int)(v1.x + v2.x) / 2, (int)(v1.y + v2.y) / 2)) {
                OverlayRenderer.renderLine(context, (int)v2.x, (int)v2.y, (int)v1.x, (int)v1.y, Colors.colorL2);
            }
            v1 = v01.reverse().add(vd).zRot(roll2).add(vecBase);
            v2 = v02.reverse().add(vd).zRot(roll2).add(vecBase);
            if (!this.edgeCheck(edge0, 2 * scale, (int)(v1.x + v2.x) / 2, (int)(v1.y + v2.y) / 2)) continue;
            OverlayRenderer.renderLine(context, (int)v2.x, (int)v2.y, (int)v1.x, (int)v1.y, Colors.colorL1);
        }
        IntStream.of(-90, -75, -60, -45, -30, -15, 0, 15, 30, 45, 60, 75, 90).forEach(value -> {
            int y = -((int)(Math.sin(Math.toRadians(value)) * 40.0));
            int x1 = 20;
            int x2 = 10;
            int x3 = -x2;
            int x4 = -x1;
            Vec3 v1 = new Vec3((double)x1, (double)y, 0.0).scale((double)scale).add(vd).zRot(roll2).add(vecBase);
            Vec3 v2 = new Vec3((double)x2, (double)y, 0.0).scale((double)scale).add(vd).zRot(roll2).add(vecBase);
            Vec3 v3 = new Vec3((double)x3, (double)y, 0.0).scale((double)scale).add(vd).zRot(roll2).add(vecBase);
            Vec3 v4 = new Vec3((double)x4, (double)y, 0.0).scale((double)scale).add(vd).zRot(roll2).add(vecBase);
            Vec3 v5 = new Vec3(0.0, (double)y, 0.0).scale((double)scale).add(vd).zRot(roll2).add(vecBase);
            if (value != 0) {
                if (this.edgeCheck(edge0, 2 * scale, (int)(v5.x + v2.x) / 2, (int)(v5.y + v2.y) / 2)) {
                    OverlayRenderer.renderLine(context, (int)v2.x, (int)v2.y, (int)v5.x, (int)v5.y, value > 0 ? Colors.colorL1 : Colors.colorL2);
                }
                if (this.edgeCheck(edge0, 2 * scale, (int)(v5.x + v3.x) / 2, (int)(v5.y + v3.y) / 2)) {
                    OverlayRenderer.renderLine(context, (int)v3.x, (int)v3.y, (int)v5.x, (int)v5.y, value > 0 ? Colors.colorL1 : Colors.colorL2);
                }
                if (value % 30 == 0) {
                    if (this.edgeCheck(edge0, 2 * scale, (int)(v1.x + v2.x) / 2, (int)(v1.y + v2.y) / 2)) {
                        OverlayRenderer.renderLine(context, (int)v2.x, (int)v2.y, (int)v1.x, (int)v1.y, value > 0 ? Colors.colorL1 : Colors.colorL2);
                    }
                    if (this.edgeCheck(edge0, 2 * scale, (int)(v4.x + v3.x) / 2, (int)(v4.y + v3.y) / 2)) {
                        OverlayRenderer.renderLine(context, (int)v3.x, (int)v3.y, (int)v4.x, (int)v4.y, value > 0 ? Colors.colorL1 : Colors.colorL2);
                    }
                }
            } else {
                Vec3 v02;
                Vec3 v01;
                Vec3 v00 = new Vec3(4.0, 0.0, 0.0).scale((double)scale);
                int i = 0;
                while (true) {
                    v01 = v00.scale((double)i).add(vd).zRot(roll2).add(vecBase);
                    v02 = v00.scale((double)(i + 1)).add((double)scale, 0.0, 0.0).add(vd).zRot(roll2).add(vecBase);
                    if (!this.edgeCheck(edge0, 2 * scale, (int)(v01.x + v02.x) / 2, (int)(v01.y + v02.y) / 2)) break;
                    OverlayRenderer.renderLine(context, (int)v02.x, (int)v02.y, (int)v01.x, (int)v01.y, Colors.colorL3);
                    ++i;
                }
                i = 0;
                while (true) {
                    v01 = v00.scale((double)i).add(vd).zRot(roll2).add(vecBase);
                    v02 = v00.scale((double)(i - 1)).add((double)(-scale), 0.0, 0.0).add(vd).zRot(roll2).add(vecBase);
                    if (!this.edgeCheck(edge0, 3 * scale, (int)(v01.x + v02.x) / 2, (int)(v01.y + v02.y) / 2)) break;
                    OverlayRenderer.renderLine(context, (int)v02.x, (int)v02.y, (int)v01.x, (int)v01.y, Colors.colorL3);
                    --i;
                }
            }
        });
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY - 19 * scale + 1, Colors.colorBG);
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX - 19 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        context.fill(baseX + 19 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        context.fill(baseX - 27 * scale, baseY + 19 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        OverlayRenderer.drawDialOutline(context, baseX, baseY, scale);
        context.fill(baseX - 18 * scale, baseY - 18 * scale, baseX + 18 * scale + 1, baseY - 17 * scale, Colors.colorSD);
        context.fill(baseX - 18 * scale, baseY - 18 * scale, baseX - 17 * scale, baseY + 18 * scale + 1, Colors.colorSD);
        context.fill(baseX - 19 * scale, baseY - 19 * scale, baseX + 19 * scale + 1, baseY - 18 * scale, Colors.colorFG);
        context.fill(baseX - 19 * scale, baseY - 19 * scale, baseX - 18 * scale, baseY + 19 * scale + 1, Colors.colorFG);
        context.fill(baseX - 19 * scale, baseY + 18 * scale + 1, baseX + 19 * scale + 1, baseY + 19 * scale + 1, Colors.colorFG);
        context.fill(baseX + 18 * scale + 1, baseY - 19 * scale, baseX + 19 * scale + 1, baseY + 19 * scale + 1, Colors.colorFG);
        context.fill(baseX - 25 * scale, baseY, baseX - 19 * scale + 1, baseY + 1, Colors.colorHD1);
        context.fill(baseX + 19 * scale, baseY, baseX + 25 * scale + 1, baseY + 1, Colors.colorHD1);
        context.fill(baseX, baseY - 25 * scale, baseX + 1, baseY - 19 * scale + 1, Colors.colorHD1);
        context.fill(baseX, baseY + 19 * scale, baseX + 1, baseY + 25 * scale + 1, Colors.colorHD1);
        if (scale > 1) {
            StringDrawer.drawString9(context, client, "AI", baseX + 20 * scale + 1, baseY + 25 * scale + 1, Colors.colorFG, false);
        } else {
            int x = baseX + 13;
            int y = baseY + 26;
            context.fill(x, y - 4, x + 1, y, Colors.colorFG);
            context.fill(x + 1, y - 5, x + 2, y - 4, Colors.colorFG);
            context.fill(x + 2, y - 4, x + 3, y, Colors.colorFG);
            context.fill(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            x = baseX + 16;
            y = baseY + 26;
            context.fill(x + 1, y - 5, x + 2, y, Colors.colorFG);
        }
    }
}

