/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.client.hud.AltIndicator;
import immersive_aircraft.client.hud.AttitudeIndicator;
import immersive_aircraft.client.hud.AzimuthIndicator;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.SpeedIndicator;
import immersive_aircraft.client.hud.VectorIndicator;
import immersive_aircraft.client.hud.WarningIndicator;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.item.upgrade.VehicleStat;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class OverlayRenderer {
    public static final OverlayRenderer INSTANCE = new OverlayRenderer();
    private static final ResourceLocation ENGINE_TEX = Main.locate("textures/gui/engine.png");
    private static final ResourceLocation POWER_TEX = Main.locate("textures/gui/power.png");
    private static final ResourceLocation ICONS_TEX = Main.locate("textures/gui/icons.png");
    private float bootUp = 0.0f;
    private float lastTime = 0.0f;
    public int tick = 0;
    static final Indicator[] INDICATORS = new Indicator[]{SpeedIndicator.INSTANCE, AltIndicator.INSTANCE, AzimuthIndicator.INSTANCE, AttitudeIndicator.INSTANCE, VectorIndicator.INSTANCE, WarningIndicator.INSTANCE};

    public static int renderOverlay(GuiGraphics context, float tickDelta, int barHeightOffset) {
        Minecraft client = Minecraft.getInstance();
        if (client.gameMode != null && client.player != null) {
            EngineVehicle aircraft;
            Indicator[] indicatorArray;
            OverlayRenderer.INSTANCE.tick = (OverlayRenderer.INSTANCE.tick + 1) % 60;
            if (Config.getInstance().showHotbarEngineGauge && (indicatorArray = client.player.getRootVehicle()) instanceof EngineVehicle) {
                aircraft = (EngineVehicle)indicatorArray;
                INSTANCE.renderAircraftGui(client, context, tickDelta, aircraft);
            }
            if ((indicatorArray = client.player.getRootVehicle()) instanceof EngineVehicle && ((aircraft = (EngineVehicle)indicatorArray).getProperties().get(VehicleStat.HUD) == 0.0f || aircraft.getProperties().get(VehicleStat.DIALS) == 0.0f)) {
                indicatorArray = INDICATORS;
                int n = indicatorArray.length;
                for (int i = 0; i < n; ++i) {
                    Indicator i2 = indicatorArray[i];
                    i2.update(client, aircraft);
                }
                if (aircraft.getProperties().get(VehicleStat.HUD) == 0.0f) {
                    INSTANCE.renderAircraftHUD(client, context, tickDelta, barHeightOffset, aircraft);
                }
                if (aircraft.getProperties().get(VehicleStat.DIALS) == 0.0f) {
                    INSTANCE.renderAircraftDials(client, context, tickDelta, barHeightOffset, aircraft);
                }
            }
            if ((indicatorArray = client.player.getRootVehicle()) instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)indicatorArray;
                INSTANCE.renderAircraftHealth(client, context, vehicle, barHeightOffset);
                return 10;
            }
        }
        return 0;
    }

    private void renderAircraftHealth(Minecraft minecraft, GuiGraphics context, VehicleEntity vehicle, int barHeightOffset) {
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        int maxHearts = 10;
        int health = (int)Math.ceil(vehicle.getHealth() * (float)maxHearts * 2.0f);
        int y = screenHeight - barHeightOffset - Config.getInstance().healthBarRow * 10;
        int ox = screenWidth / 2 + 91;
        for (int i = 0; i < maxHearts; ++i) {
            int u = 52;
            int x = ox - i * 8 - 9;
            context.blit(ICONS_TEX, x, y, (float)u, 9.0f, 9, 9, 64, 64);
            if (i * 2 + 1 < health) {
                context.blit(ICONS_TEX, x, y, 0.0f, 0.0f, 9, 9, 64, 64);
            }
            if (i * 2 + 1 != health) continue;
            context.blit(ICONS_TEX, x, y, 10.0f, 0.0f, 9, 9, 64, 64);
        }
    }

    private void renderAircraftGui(Minecraft client, GuiGraphics context, float tickDelta, EngineVehicle aircraft) {
        assert (client.level != null);
        if (aircraft.getGuiStyle() == EngineVehicle.GUI_STYLE.ENGINE) {
            int frame;
            float time = (float)(client.level.getGameTime() % 65536L) + tickDelta;
            float delta = time - this.lastTime;
            this.lastTime = time;
            if (aircraft.getEngineTarget() > 0.0f && (double)aircraft.getEnginePower() > 0.001) {
                if (this.bootUp < 1.0f) {
                    this.bootUp = Math.min(1.0f, this.bootUp + delta * 0.2f);
                    frame = (int)(this.bootUp * 5.0f);
                } else {
                    int FPS = 30;
                    int animation = (int)(aircraft.engineRotation.getSmooth(tickDelta) / 20.0f * 30.0f);
                    frame = 5 + animation % 6;
                }
            } else if (this.bootUp > 0.0f) {
                this.bootUp = Math.max(0.0f, this.bootUp - delta * 0.1f);
                frame = 10 + (int)((1.0 - (double)this.bootUp) * 10.0);
            } else {
                frame = 20;
            }
            int powerFrame = (int)((double)((1.0f - aircraft.getEnginePower()) * 10.0f) + 10.5);
            int powerFrameTarget = (int)((double)((1.0f - aircraft.getEngineTarget()) * 10.0f) + 10.5);
            int x = client.getWindow().getGuiScaledWidth() / 2;
            int y = client.getWindow().getGuiScaledHeight() - 37;
            if (client.gameMode != null && !client.gameMode.hasExperience()) {
                y += 7;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.blit(ENGINE_TEX, x - 9, y - 9, (float)(frame % 5 * 18), (float)(Math.floorDiv(frame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            context.blit(POWER_TEX, x - 9, y - 9, (float)(powerFrame % 5 * 18), (float)(Math.floorDiv(powerFrame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.blit(POWER_TEX, x - 9, y - 9, (float)(powerFrameTarget % 5 * 18), (float)(Math.floorDiv(powerFrameTarget, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderAircraftHUD(Minecraft client, GuiGraphics context, float tickDelta, int barHeightOffset, EngineVehicle aircraft) {
        int screenWidth = client.getWindow().getGuiScaledWidth();
        int screenHeight = client.getWindow().getGuiScaledHeight();
        LocalPlayer player = client.player;
        int xC = screenWidth / 2;
        int yC = screenHeight / 2;
        int sqD = Math.min(screenWidth * 4 / 10, screenHeight * 4 / 10);
        int rcX = xC;
        int rcY = yC;
        int rc2X = xC;
        int rc2Y = yC;
        int alpha = 255;
        float relXR = 0.0f;
        float relYR = 0.0f;
        float acYR = aircraft.yRotO;
        float acZR = aircraft.roll;
        boolean fullhud = false;
        if (player != null) {
            fullhud = client.options.getCameraType() == CameraType.FIRST_PERSON;
            float playerXR = player.xRotO;
            float playerYR = player.yRotO;
            relXR = playerXR - 10.0f;
            relYR = Math.abs(playerYR - acYR) < Math.abs(360.0f - (playerYR - acYR)) ? playerYR - acYR : 360.0f - (playerYR - acYR);
            float xDt = Math.min(Math.max(0.0f, Math.abs(relXR) - 5.0f) / 25.0f, 1.0f);
            float yDt = Math.min(Math.max(0.0f, Math.abs(relYR) - 5.0f) / 25.0f, 1.0f);
            alpha = (int)((float)alpha * Math.min(1.0f - xDt, 1.0f - yDt));
            rcY = (int)((float)rcY - relXR / 30.0f * (float)sqD * 0.8f);
            rcY -= sqD * 3 / 16;
            rcY = (int)((float)rcY + Math.abs(relYR) / 30.0f * (float)sqD * 0.1f);
            rcY = (int)((float)rcY + acZR * relYR * (float)sqD * 5.0E-4f);
            rcX = (int)((float)rcX - relYR / 30.0f * (float)sqD * 0.9f);
            rcX = (int)((float)rcX - acZR * (float)sqD * 0.01f);
            rc2Y = (int)((float)rc2Y - relXR / 30.0f * (float)sqD * 0.4f);
            rc2Y -= sqD * 4 / 16;
            rc2Y = (int)((float)rc2Y + Math.abs(relYR) / 30.0f * (float)sqD * 0.1f);
            rc2Y = (int)((float)rc2Y + acZR * relYR * (float)sqD * 5.0E-4f);
            rc2X = (int)((float)rc2X - relYR / 30.0f * (float)sqD * 0.5f);
            rc2X = (int)((float)rc2X - acZR * (float)sqD * 0.01f);
        }
        if (fullhud) {
            int color = FastColor.ARGB32.color((int)((int)Math.round((double)alpha * 0.8)), (int)255, (int)255, (int)255);
            int[] p = OverlayRenderer.vp(rcX, rcY, sqD / 2, (float)Math.toRadians(relXR + 15.0f), (float)Math.toRadians(relYR));
            OverlayRenderer.renderLine(context, p[0], p[1], p[2], p[3], color);
            OverlayRenderer.renderLine(context, p[0], p[1], p[4], p[5], color);
            OverlayRenderer.renderLine(context, p[4], p[5], p[6], p[7], color);
            OverlayRenderer.renderLine(context, p[2], p[3], p[6], p[7], color);
            int[] edge = new int[]{(p[1] + p[3]) / 2, (p[5] + p[7]) / 2, (p[0] + p[4]) / 2, (p[2] + p[6]) / 2};
            alpha = (int)Math.max(Math.min((float)alpha, 204.0f), 102.0f);
            if (aircraft.mslWarning > 0 && (Math.floorDiv(this.tick, 6) & 1) != 0) {
                alpha = alpha * 6 / 5;
            }
            if (aircraft.getEnginePower() <= 0.05f) {
                alpha = (int)((float)alpha * 0.5f);
            }
            color = FastColor.ARGB32.color((int)alpha, (int)239, (int)195, (int)134);
            SpeedIndicator.INSTANCE.drawHUD(context, client, rc2X - sqD * 6 / 16 + 2, rc2Y, sqD * 5 / 6, aircraft, color, edge);
            AltIndicator.INSTANCE.drawHUD(context, client, rc2X + sqD * 6 / 16 + 2, rc2Y, sqD * 5 / 6, aircraft, color, edge);
            AzimuthIndicator.INSTANCE.drawHUD(context, client, rc2X, rc2Y - sqD * 6 / 16, sqD * 5 / 6, aircraft, color, edge);
            AttitudeIndicator.INSTANCE.drawHUD(context, client, rc2X, rc2Y, sqD * 5 / 6, aircraft, color, edge);
            VectorIndicator.INSTANCE.drawHUD(context, client, rc2X, rc2Y, sqD * 5 / 6, aircraft, color, edge);
            WarningIndicator.INSTANCE.drawHUD(context, client, rc2X, rc2Y + sqD * 3 / 16, sqD * 5 / 6, aircraft, color, edge);
        } else {
            int color = FastColor.ARGB32.color((int)255, (int)239, (int)195, (int)134);
            int dashY = screenHeight - barHeightOffset - Config.getInstance().healthBarRow * 10 - 10;
            for (Indicator i : new Indicator[]{SpeedIndicator.INSTANCE, AltIndicator.INSTANCE, AzimuthIndicator.INSTANCE, WarningIndicator.INSTANCE}) {
                i.drawDashboard(context, client, xC, dashY, aircraft, color);
            }
        }
    }

    private void renderAircraftDials(Minecraft client, GuiGraphics context, float tickDelta, int barHeightOffset, EngineVehicle aircraft) {
        int screenWidth = client.getWindow().getGuiScaledWidth();
        int screenHeight = client.getWindow().getGuiScaledHeight();
        int scale = Math.max(1, Math.min(screenWidth / 240, screenHeight / 240));
        SpeedIndicator.INSTANCE.drawDials(context, client, screenWidth - 84 * scale, screenHeight - 28 * scale, scale, aircraft);
        AltIndicator.INSTANCE.drawDials(context, client, screenWidth - 28 * scale, screenHeight - 28 * scale, scale, aircraft);
        AzimuthIndicator.INSTANCE.drawDials(context, client, screenWidth - 56 * scale, screenHeight - 120 * scale, scale, aircraft);
        AttitudeIndicator.INSTANCE.drawDials(context, client, screenWidth - 84 * scale, screenHeight - 84 * scale, scale, aircraft);
        VectorIndicator.INSTANCE.drawDials(context, client, screenWidth - 28 * scale, screenHeight - (56 * scale + 28 * Math.min(2, scale)), scale, aircraft);
        WarningIndicator.INSTANCE.drawDials(context, client, screenWidth - (112 * scale + 14), screenHeight - 88 * scale, scale, aircraft);
    }

    public static void renderLine(GuiGraphics context, int x01, int y01, int x02, int y02, int color) {
        OverlayRenderer.renderLine(context, x01, y01, x02, y02, color, false);
    }

    public static void renderLine(GuiGraphics context, int x01, int y01, int x02, int y02, int color, boolean dotLine) {
        OverlayRenderer.renderLine(context, x01, y01, x02, y02, color, dotLine, false);
    }

    public static void renderLine(GuiGraphics context, int x01, int y01, int x02, int y02, int color, boolean dotLine, boolean dropShadow) {
        if (Math.abs(y02 - y01) > Math.abs(x02 - x01)) {
            int x2;
            int y1 = Math.min(y01, y02);
            int y2 = Math.max(y01, y02);
            int x1 = y02 > y01 ? x01 : x02;
            int n = x2 = y02 > y01 ? x02 : x01;
            if (x1 == x2 && !dotLine) {
                if (dropShadow) {
                    context.fill(x01 + 1, y01 + 1, x01 + 2, y02 + 1, FastColor.ARGB32.color((int)127, (int)0, (int)0, (int)0));
                }
                context.fill(x01, y01, x01 + 1, y02 + 1, color);
                return;
            }
            PrimitiveIterator.OfInt it = IntStream.range(y1, y2 + 1).iterator();
            while (it.hasNext()) {
                int py = it.nextInt();
                int dx = x1 + (int)((float)(x2 - x1) * ((float)(py - y1) / (float)(y2 - y1)));
                if (dotLine && (py & 1) == 0) continue;
                if (dropShadow) {
                    context.fill(dx + 1, py + 1, dx + 2, py + 2, FastColor.ARGB32.color((int)127, (int)0, (int)0, (int)0));
                }
                context.fill(dx, py, dx + 1, py + 1, color);
            }
        } else {
            int y2;
            int x1 = Math.min(x01, x02);
            int x2 = Math.max(x01, x02);
            int y1 = x02 > x01 ? y01 : y02;
            int n = y2 = x02 > x01 ? y02 : y01;
            if (y1 == y2 && !dotLine) {
                if (dropShadow) {
                    context.fill(x01 + 1, y01 + 1, x02 + 1, y01 + 2, FastColor.ARGB32.color((int)127, (int)0, (int)0, (int)0));
                }
                context.fill(x01, y01, x02 + 1, y01 + 1, color);
                return;
            }
            PrimitiveIterator.OfInt it = IntStream.range(x1, x2 + 1).iterator();
            while (it.hasNext()) {
                int px = it.nextInt();
                int dy = y1 + (int)((float)(y2 - y1) * ((float)(px - x1) / (float)(x2 - x1)));
                if (dotLine && (px & 1) == 0) continue;
                if (dropShadow) {
                    context.fill(px + 1, dy + 1, px + 2, dy + 2, FastColor.ARGB32.color((int)127, (int)0, (int)0, (int)0));
                }
                context.fill(px, dy, px + 1, dy + 1, color);
            }
        }
    }

    private static int[] vp(int ix, int iy, int r, float rx, float ry) {
        int x1 = -r;
        int y1 = -r;
        int x2 = r;
        int y2 = -r;
        int x3 = -r;
        int y3 = r;
        int x4 = r;
        int y4 = r;
        x1 = (int)((double)x1 * Math.cos(ry));
        x2 = (int)((double)x2 * Math.cos(ry));
        x3 = (int)((double)x3 * Math.cos(ry));
        x4 = (int)((double)x4 * Math.cos(ry));
        y1 = (int)((double)y1 * Math.cos(rx));
        y2 = (int)((double)y2 * Math.cos(rx));
        y3 = (int)((double)y3 * Math.cos(rx));
        y4 = (int)((double)y4 * Math.cos(rx));
        float x11 = Math.abs(rx) * (float)Math.sin(rx) * (float)r / 1.8f;
        x1 = (int)((float)x1 - x11);
        x2 = (int)((float)x2 + x11);
        x3 = (int)((float)x3 + x11);
        x4 = (int)((float)x4 - x11);
        float y11 = Math.abs(ry) * (float)Math.sin(ry) * (float)r / 1.8f;
        y1 = (int)((float)y1 - y11);
        y2 = (int)((float)y2 + y11);
        y3 = (int)((float)y3 + y11);
        y4 = (int)((float)y4 - y11);
        return new int[]{ix + x1, iy + y1, ix + x2, iy + y2, ix + x3, iy + y3, ix + x4, iy + y4};
    }

    public static void drawScrew(GuiGraphics context, int x, int y, int scale, boolean r, int color) {
        OverlayRenderer.renderLine(context, x - scale, y - scale * 2, x + scale, y - scale * 2, color);
        OverlayRenderer.renderLine(context, x - scale * 2, y - scale, x - scale * 2, y + scale, color);
        OverlayRenderer.renderLine(context, x - scale, y + scale * 2, x + scale, y + scale * 2, color);
        OverlayRenderer.renderLine(context, x + scale * 2, y - scale, x + scale * 2, y + scale, color);
        if (r) {
            OverlayRenderer.renderLine(context, x - scale, y - scale, x + scale, y + scale, color);
        } else {
            OverlayRenderer.renderLine(context, x + scale, y - scale, x - scale, y + scale, color);
        }
    }

    public static void drawDialOutline(GuiGraphics context, int baseX, int baseY, int scale) {
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY - 25 * scale, Colors.colorFG);
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX - 25 * scale, baseY + 27 * scale + 1, Colors.colorFG);
        context.fill(baseX - 27 * scale, baseY + 25 * scale + 1, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorFG);
        context.fill(baseX + 25 * scale + 1, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX - 22 * scale, baseY - 22 * scale, scale, true, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX + 22 * scale, baseY - 22 * scale, scale, false, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX - 22 * scale, baseY + 22 * scale, scale, false, Colors.colorFG);
        OverlayRenderer.drawScrew(context, baseX + 22 * scale, baseY + 22 * scale, scale, true, Colors.colorFG);
    }
}

