/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TurtleSuckCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        Level world = turtle.getLevel();
        BlockPos turtlePosition = turtle.getPosition();
        BlockPos blockPosition = turtlePosition.relative(direction);
        Direction side = direction.getOpposite();
        ContainerTransfer inventory = PlatformHelper.get().getContainer((ServerLevel)world, blockPosition, side);
        if (inventory != null) {
            int transferred = inventory.moveTo(TurtleUtil.getOffsetInventory(turtle), this.quantity);
            return switch (transferred) {
                case -2 -> TurtleCommandResult.failure("No space for items");
                case -1 -> TurtleCommandResult.failure("No items to take");
                default -> {
                    turtle.playAnimation(TurtleAnimation.WAIT);
                    yield TurtleCommandResult.success();
                }
            };
        }
        AABB aabb = new AABB((double)blockPosition.getX(), (double)blockPosition.getY(), (double)blockPosition.getZ(), (double)blockPosition.getX() + 1.0, (double)blockPosition.getY() + 1.0, (double)blockPosition.getZ() + 1.0);
        List list = world.getEntitiesOfClass(ItemEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (ItemEntity entity : list) {
            ItemStack leaveStack;
            ItemStack storeStack;
            ItemStack stack = entity.getItem().copy();
            if (stack.getCount() > this.quantity) {
                storeStack = stack.split(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = ItemStack.EMPTY;
            }
            int oldCount = storeStack.getCount();
            ItemStack remainder = InventoryUtil.storeItemsFromOffset(turtle.getInventory(), storeStack, turtle.getSelectedSlot());
            if (remainder.getCount() == oldCount) continue;
            if (remainder.isEmpty() && leaveStack.isEmpty()) {
                entity.discard();
            } else if (remainder.isEmpty()) {
                entity.setItem(leaveStack);
            } else if (leaveStack.isEmpty()) {
                entity.setItem(remainder);
            } else {
                leaveStack.grow(remainder.getCount());
                entity.setItem(leaveStack);
            }
            world.globalLevelEvent(1000, turtlePosition, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

