/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TurtleCompareCommand
implements TurtleCommand {
    private final InteractDirection direction;

    public TurtleCompareCommand(InteractDirection direction) {
        this.direction = direction;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        Direction direction = this.direction.toWorldDir(turtle);
        ItemStack selectedStack = turtle.getInventory().getItem(turtle.getSelectedSlot());
        Level world = turtle.getLevel();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.relative(direction);
        ItemStack lookAtStack = ItemStack.EMPTY;
        if (!world.isEmptyBlock(newPosition)) {
            BlockState lookAtState = world.getBlockState(newPosition);
            Block lookAtBlock = lookAtState.getBlock();
            if (!lookAtState.isAir()) {
                block0: for (int i = 0; i < 5 && lookAtStack.isEmpty(); ++i) {
                    List drops = Block.getDrops((BlockState)lookAtState, (ServerLevel)((ServerLevel)world), (BlockPos)newPosition, (BlockEntity)world.getBlockEntity(newPosition));
                    if (drops.isEmpty()) continue;
                    for (ItemStack drop : drops) {
                        if (drop.getItem() != lookAtBlock.asItem()) continue;
                        lookAtStack = drop;
                        continue block0;
                    }
                }
                if (lookAtStack.isEmpty()) {
                    lookAtStack = new ItemStack((ItemLike)lookAtBlock);
                }
            }
        }
        return selectedStack.getItem() == lookAtStack.getItem() ? TurtleCommandResult.success() : TurtleCommandResult.failure();
    }
}

