/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;

public sealed interface PocketHolder {
    public ServerLevel level();

    public Vec3 pos();

    public BlockPos blockPos();

    public boolean isValid(ServerComputer var1);

    public void setChanged();

    default public boolean isTerminalAlwaysVisible() {
        return false;
    }

    public record LecternHolder(CustomLecternBlockEntity lectern) implements PocketHolder
    {
        @Override
        public ServerLevel level() {
            return (ServerLevel)this.lectern.getLevel();
        }

        @Override
        public Vec3 pos() {
            return Vec3.atCenterOf((Vec3i)this.lectern.getBlockPos());
        }

        @Override
        public BlockPos blockPos() {
            return this.lectern.getBlockPos();
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return !this.lectern().isRemoved() && PocketComputerItem.isServerComputer(computer, this.lectern.getItem());
        }

        @Override
        public void setChanged() {
            BlockEntityHelpers.updateBlock(this.lectern());
        }

        @Override
        public boolean isTerminalAlwaysVisible() {
            return true;
        }
    }

    public static final class ItemEntityHolder
    extends Record
    implements EntityHolder {
        private final ItemEntity entity;

        public ItemEntityHolder(ItemEntity entity) {
            this.entity = entity;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().isAlive() && PocketComputerItem.isServerComputer(computer, this.entity().getItem());
        }

        @Override
        public void setChanged() {
            this.entity.setItem(this.entity.getItem().copy());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this, o);
        }

        public ItemEntity entity() {
            return this.entity;
        }
    }

    public static final class PlayerHolder
    extends Record
    implements EntityHolder {
        private final ServerPlayer entity;
        private final int slot;

        public PlayerHolder(ServerPlayer entity, int slot) {
            this.entity = entity;
            this.slot = slot;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().isAlive() && PocketComputerItem.isServerComputer(computer, this.entity().getInventory().getItem(this.slot()));
        }

        @Override
        public void setChanged() {
            this.entity.getInventory().setChanged();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this, o);
        }

        public ServerPlayer entity() {
            return this.entity;
        }

        public int slot() {
            return this.slot;
        }
    }

    public static sealed interface EntityHolder
    extends PocketHolder
    permits PlayerHolder, ItemEntityHolder {
        public Entity entity();

        @Override
        default public ServerLevel level() {
            return (ServerLevel)this.entity().level();
        }

        @Override
        default public Vec3 pos() {
            return this.entity().getEyePosition();
        }

        @Override
        default public BlockPos blockPos() {
            return this.entity().blockPosition();
        }
    }
}

