/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileAttributes;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.Mount;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public abstract class AbstractInMemoryMount<T extends FileEntry<T>>
implements Mount {
    protected @Nullable T root;

    protected final @Nullable T get(String path) {
        T lastEntry = this.root;
        int lastIndex = 0;
        while (lastEntry != null && lastIndex < path.length()) {
            int nextIndex = path.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = path.length();
            }
            lastEntry = ((FileEntry)lastEntry).children == null ? null : (FileEntry)((FileEntry)lastEntry).children.get(path.substring(lastIndex, nextIndex));
            lastIndex = nextIndex + 1;
        }
        return lastEntry;
    }

    @Override
    public final boolean exists(String path) {
        return this.get(path) != null;
    }

    @Override
    public final boolean isDirectory(String path) {
        T file = this.get(path);
        return file != null && ((FileEntry)file).isDirectory();
    }

    @Override
    public final void list(String path, List<String> contents) throws IOException {
        T file = this.get(path);
        if (file == null) {
            throw new FileOperationException(path, "No such file");
        }
        if (((FileEntry)file).children == null) {
            throw new FileOperationException(path, "Not a directory");
        }
        contents.addAll(((FileEntry)file).children.keySet());
    }

    @Override
    public final long getSize(String path) throws IOException {
        T file = this.get(path);
        if (file == null) {
            throw new FileOperationException(path, "No such file");
        }
        return this.getSize(path, file);
    }

    protected abstract long getSize(String var1, T var2) throws IOException;

    @Override
    public final SeekableByteChannel openForRead(String path) throws IOException {
        T file = this.get(path);
        if (file == null) {
            throw new FileOperationException(path, "No such file");
        }
        if (((FileEntry)file).isDirectory()) {
            throw new FileOperationException(path, "Not a file");
        }
        return this.openForRead(path, file);
    }

    protected abstract SeekableByteChannel openForRead(String var1, T var2) throws IOException;

    @Override
    public final BasicFileAttributes getAttributes(String path) throws IOException {
        T file = this.get(path);
        if (file == null) {
            throw new FileOperationException(path, "No such file");
        }
        return this.getAttributes(path, file);
    }

    protected BasicFileAttributes getAttributes(String path, T file) throws IOException {
        return new FileAttributes(((FileEntry)file).isDirectory(), this.getSize(path, file));
    }

    protected T getOrCreateChild(T lastEntry, String localPath, Function<String, T> factory) {
        int lastIndex = 0;
        while (lastIndex < localPath.length()) {
            FileEntry nextEntry;
            int nextIndex = localPath.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = localPath.length();
            }
            String part = localPath.substring(lastIndex, nextIndex);
            if (((FileEntry)lastEntry).children == null) {
                ((FileEntry)lastEntry).children = new HashMap(0);
            }
            if ((nextEntry = (FileEntry)((FileEntry)lastEntry).children.get(part)) == null || !nextEntry.isDirectory()) {
                nextEntry = (FileEntry)factory.apply(localPath.substring(0, nextIndex));
                ((FileEntry)lastEntry).children.put(part, nextEntry);
            }
            lastEntry = nextEntry;
            lastIndex = nextIndex + 1;
        }
        return lastEntry;
    }

    protected static class FileEntry<T extends FileEntry<T>> {
        public @Nullable Map<String, T> children;

        protected FileEntry() {
        }

        public boolean isDirectory() {
            return this.children != null;
        }
    }
}

