/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import java.util.Arrays;
import java.util.function.IntFunction;

final class IntCache<T> {
    private final IntFunction<T> factory;
    private volatile Object[] cache = new Object[16];

    IntCache(IntFunction<T> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        Object current;
        if (index < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (index < this.cache.length && (current = this.cache[index]) != null) {
            return (T)current;
        }
        IntCache intCache = this;
        synchronized (intCache) {
            Object current2;
            if (index >= this.cache.length) {
                this.cache = Arrays.copyOf(this.cache, Math.max(this.cache.length * 2, index + 1));
            }
            if ((current2 = this.cache[index]) == null) {
                this.cache[index] = current2 = this.factory.apply(index);
            }
            return (T)current2;
        }
    }
}

