/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.rei;

import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.screen.AbstractStorageTerminalScreen;
import com.tom.storagemod.util.IAutoFillTerminal;
import java.util.ArrayList;
import java.util.HashSet;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ReiTransferHandler
implements TransferHandler {
    private CategoryIdentifier<?> CRAFTING = CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting");

    public TransferHandler.Result handle(TransferHandler.Context context) {
        if (context.getMenu() instanceof IAutoFillTerminal) {
            ResourceLocation recipeId;
            if (!context.getDisplay().getCategoryIdentifier().equals(this.CRAFTING) || context.getMinecraft().screen == context.getContainerScreen()) {
                return TransferHandler.Result.createNotApplicable();
            }
            AbstractContainerScreen abstractContainerScreen = context.getContainerScreen();
            if (abstractContainerScreen instanceof AbstractStorageTerminalScreen) {
                AbstractStorageTerminalScreen scr = (AbstractStorageTerminalScreen)abstractContainerScreen;
                if (!context.isActuallyCrafting() && !scr.isSmartItemSearchOn()) {
                    return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
                }
            }
            Display recipe = context.getDisplay();
            ItemStack[][] stacks = (ItemStack[][])recipe.getInputEntries().stream().map(l -> (ItemStack[])l.stream().filter(es -> es.getDefinition().getValueType() == ItemStack.class).map(es -> es.getValue()).filter(e -> e != null).toArray(ItemStack[]::new)).toArray(x$0 -> new ItemStack[x$0][]);
            IAutoFillTerminal term = (IAutoFillTerminal)context.getMenu();
            ArrayList<Integer> missing = new ArrayList<Integer>();
            int width = recipe instanceof SimpleGridMenuDisplay ? ((SimpleGridMenuDisplay)recipe).getWidth() : Integer.MAX_VALUE;
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            int i = 0;
            for (ItemStack[] list : stacks) {
                if (list.length > 0) {
                    boolean found = false;
                    for (ItemStack stack : list) {
                        if (stack == null || context.getMinecraft().player.getInventory().findSlotMatchingItem(stack) == -1) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        for (ItemStack stack : list) {
                            StoredItemStack s = new StoredItemStack(stack);
                            if (!stored.contains(s)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        missing.add(width == 1 ? i * 3 : (width == 2 ? i % 2 + i / 2 * 3 : i));
                    }
                }
                ++i;
            }
            if (context.isActuallyCrafting() && (recipeId = this.getRecipe(recipe)) != null && !Minecraft.getInstance().level.getRecipeManager().byKey(recipeId).isEmpty()) {
                CompoundTag compound = new CompoundTag();
                compound.putString("fill", recipeId.toString());
                term.sendMessage(compound);
                return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
            }
            if (!missing.isEmpty()) {
                return TransferHandler.Result.createSuccessful().color(1739237888).blocksFurtherHandling(false).renderer((gr, mouseX, mouseY, delta, widgets, bounds, d) -> {
                    int i = 0;
                    for (Widget widget : widgets) {
                        if (!(widget instanceof Slot) || ((Slot)widget).getNoticeMark() != 1 || !missing.contains(i++)) continue;
                        gr.pose().pushPose();
                        gr.pose().translate(0.0f, 0.0f, 400.0f);
                        Rectangle innerBounds = ((Slot)widget).getInnerBounds();
                        gr.fill(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                        gr.pose().popPose();
                    }
                });
            }
            return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
        }
        return TransferHandler.Result.createNotApplicable();
    }

    private ResourceLocation getRecipe(Display display) {
        ResourceLocation resourceLocation;
        Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
        if (origin instanceof RecipeHolder) {
            RecipeHolder holder = (RecipeHolder)origin;
            resourceLocation = holder.id();
        } else {
            resourceLocation = null;
        }
        return resourceLocation;
    }
}

