/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.noise;

import java.util.Random;
import mod.bluestaggo.modernerbeta.settings.component.PerlinNoiseSettings;
import mod.bluestaggo.modernerbeta.util.noise.PerlinNoise;
import net.minecraft.util.Mth;

public class PerlinOctaveNoise {
    private final PerlinNoiseSettings settings;
    private final PerlinNoise[] noises;
    private final int octaves;

    public PerlinOctaveNoise(Random random, int octaves, PerlinNoiseSettings settings) {
        this.noises = new PerlinNoise[octaves];
        this.octaves = octaves;
        this.settings = settings;
        for (int i = 0; i < octaves; ++i) {
            this.noises[i] = new PerlinNoise(random, settings);
        }
    }

    public double[] sampleArray(double x, double y, double z, int sizeX, int sizeY, int sizeZ, double scaleX, double scaleY, double scaleZ) {
        double[] noise = new double[sizeX * sizeY * sizeZ];
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x;
            double offZ = z;
            if (this.settings.wrapped()) {
                long offXCoord = Mth.lfloor((double)(offX *= frequency * scaleX));
                long offZCoord = Mth.lfloor((double)(offZ *= frequency * scaleZ));
                offX -= (double)offXCoord;
                offZ -= (double)offZCoord;
                offX += (double)(offXCoord %= 0x1000000L);
                offZ += (double)(offZCoord %= 0x1000000L);
                offX /= frequency * scaleX;
                offZ /= frequency * scaleX;
            }
            if (!this.settings.alpha2DSampling() && sizeY == 1) {
                int ndx = 0;
                for (int sX = 0; sX < sizeX; ++sX) {
                    for (int sZ = 0; sZ < sizeZ; ++sZ) {
                        double curX = (x + (double)sX) * scaleX;
                        double curZ = (z + (double)sZ) * scaleZ;
                        int n = ndx++;
                        noise[n] = noise[n] + this.noises[i].sampleXZ(curX, curZ, frequency);
                    }
                }
            } else {
                this.noises[i].sample(noise, offX, y, offZ, sizeX, sizeY, sizeZ, scaleX * frequency, scaleY * frequency, scaleZ * frequency, frequency);
            }
            frequency /= 2.0;
        }
        return noise;
    }

    public final double sampleXY(double x, double y) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.noises[i].sample(x / frequency, y / frequency) * frequency;
            frequency *= 2.0;
        }
        return total;
    }

    public final double sample(double x, double y, double z) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x / frequency;
            double offZ = z / frequency;
            if (this.settings.wrapped()) {
                long offXCoord = Mth.lfloor((double)offX);
                long offZCoord = Mth.lfloor((double)offZ);
                offX -= (double)offXCoord;
                offZ -= (double)offZCoord;
                offX += (double)(offXCoord %= 0x1000000L);
                offZ += (double)(offZCoord %= 0x1000000L);
            }
            total += this.noises[i].sample(offX, y / frequency, offZ) * frequency;
            frequency *= 2.0;
        }
        return total;
    }

    public final double sampleXZ(double x, double z, double scaleX, double scaleZ) {
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x * scaleX * frequency;
            double offZ = z * scaleZ * frequency;
            if (this.settings.wrapped()) {
                long offXCoord = Mth.lfloor((double)offX);
                long offZCoord = Mth.lfloor((double)offZ);
                offX -= (double)offXCoord;
                offZ -= (double)offZCoord;
                offX += (double)(offXCoord %= 0x1000000L);
                offZ += (double)(offZCoord %= 0x1000000L);
            }
            total += this.noises[i].sampleXZ(offX, offZ, frequency);
            frequency /= 2.0;
        }
        return total;
    }

    public final double sample(double x, double y, double z, double scaleX, double scaleY, double scaleZ) {
        if (this.settings.infdevNoiseScaling()) {
            return this.sample(x * scaleX, y * scaleY, z * scaleZ);
        }
        double total = 0.0;
        double frequency = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double offX = x * scaleX * frequency;
            double offZ = z * scaleZ * frequency;
            if (this.settings.wrapped()) {
                long offXCoord = Mth.lfloor((double)offX);
                long offZCoord = Mth.lfloor((double)offZ);
                offX -= (double)offXCoord;
                offZ -= (double)offZCoord;
                offX += (double)(offXCoord %= 0x1000000L);
                offZ += (double)(offZCoord %= 0x1000000L);
            }
            total += this.noises[i].sampleXYZ(offX, y * scaleY * frequency, offZ, scaleY * frequency, y * scaleY * frequency) / frequency;
            frequency /= 2.0;
        }
        return total;
    }
}

