/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public final class VersionCompat {
    public static final Block SHORT_GRASS = Blocks.SHORT_GRASS;
    public static final String BIOME_GET_PRECIPITATION_TARGET = "Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;";

    public static <T> T accessPool(SimpleWeightedRandomList<T> pool, RandomSource random) {
        return pool.getRandomValue(random).orElseThrow();
    }

    public static <T> T getWeightedValue(WeightedEntry.Wrapper<T> weighted) {
        return (T)weighted.data();
    }

    public static <T> void forEachValueInPool(SimpleWeightedRandomList<T> pool, Consumer<T> consumer) {
        for (WeightedEntry.Wrapper entry : pool.unwrap()) {
            consumer.accept(VersionCompat.getWeightedValue(entry));
        }
    }

    public static void addSpawnEntry(MobSpawnSettings.Builder spawnSettings, MobCategory spawnGroup, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        spawnSettings.addSpawn(spawnGroup, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
    }

    public static void setBlockState(ChunkAccess chunk, BlockPos pos, BlockState blockState) {
        chunk.setBlockState(pos, blockState, false);
    }

    public static void setBlockState(ChunkAccess chunk, BlockPos pos, BlockState blockState, int flags) {
        chunk.setBlockState(pos, blockState, (flags & 0x40) != 0);
    }

    public static int getTopYExclusive(LevelHeightAccessor heightLimitView) {
        return heightLimitView.getMaxBuildHeight();
    }

    public static <T> T unwrap(T t) {
        return t;
    }

    public static <T> T unwrap(Optional<T> optional) {
        return optional.orElseThrow();
    }

    public static <T> T unwrapOrElse(T t, T orElse) {
        return t;
    }

    public static <T> T unwrapOrElse(Optional<T> optional, T orElse) {
        return optional.orElse(orElse);
    }

    public static <T> T getOrThrow(DataResult<T> result) {
        return (T)result.getOrThrow();
    }

    public static ResourceLocation id(String string) {
        return ResourceLocation.parse((String)string);
    }

    public static ResourceLocation id(String namespace, String location) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)location);
    }

    public static ResourceLocation vanillaId(String string) {
        return ResourceLocation.withDefaultNamespace((String)string);
    }

    public static String tagsDirPath(ResourceKey<? extends Registry<?>> resourceKey) {
        return Registries.tagsDirPath(resourceKey);
    }

    public static String elementsDirPath(ResourceKey<? extends Registry<?>> resourceKey) {
        return Registries.elementsDirPath(resourceKey);
    }

    public static <O> MapCodec<O> createMaybeMapCodec(Function<RecordCodecBuilder.Instance<O>, ? extends App<RecordCodecBuilder.Mu<O>, O>> builder) {
        return RecordCodecBuilder.mapCodec(builder);
    }

    public static Biome.BiomeBuilder buildBiomeWithColors(Biome.BiomeBuilder builder, int grassColor, int foliageColor, int skyColor, int fogColor, int waterColor, int waterFogColor) {
        return builder.specialEffects(new BiomeSpecialEffects.Builder().grassColorOverride(grassColor).foliageColorOverride(foliageColor).skyColor(skyColor).fogColor(fogColor).waterFogColor(waterFogColor).waterColor(waterColor).build());
    }

    public static Biome.BiomeBuilder buildBiomeWithColors(Biome.BiomeBuilder builder, int skyColor, int fogColor, int waterColor, int waterFogColor) {
        return builder.specialEffects(new BiomeSpecialEffects.Builder().skyColor(skyColor).fogColor(fogColor).waterFogColor(waterFogColor).waterColor(waterColor).build());
    }

    public static double clampedLerp(double start, double end, double delta) {
        return Mth.clampedLerp((double)start, (double)end, (double)delta);
    }
}

