/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Type;
import java.util.Set;
import mod.bluestaggo.modernerbeta.mixin.RegistryOpsAccessor;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class CodecUtil {
    public static <T> RecordCodecBuilder<T, RegistryOps.RegistryInfoLookup> registryLookupCodec() {
        return ExtraCodecs.retrieveContext(dynamicOps -> {
            DataResult dataResult;
            if (dynamicOps instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)dynamicOps;
                dataResult = DataResult.success((Object)((RegistryOpsAccessor)registryOps).getLookupProvider());
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(object -> null);
    }

    public static <E, O> RecordCodecBuilder<O, HolderLookup<E>> retrieveLookup(ResourceKey<? extends Registry<? extends E>> registry) {
        return ExtraCodecs.retrieveContext(dynamicOps -> {
            DataResult dataResult;
            if (dynamicOps instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)dynamicOps;
                dataResult = ((RegistryOpsAccessor)registryOps).getLookupProvider().lookup(registry).map(registryInfo -> {
                    HolderGetter patt1$temp;
                    HolderLookup lookup;
                    HolderLookup foundLookup = null;
                    HolderOwner patt0$temp = registryInfo.owner();
                    if (patt0$temp instanceof HolderLookup) {
                        foundLookup = lookup = (HolderLookup)patt0$temp;
                    }
                    if ((patt1$temp = registryInfo.getter()) instanceof HolderLookup) {
                        foundLookup = lookup = (HolderLookup)patt1$temp;
                    }
                    if (foundLookup != null) {
                        return DataResult.success((Object)foundLookup, (Lifecycle)registryInfo.elementsLifecycle());
                    }
                    return DataResult.error(() -> "Could not get HolderLookup from RegistryOps");
                }).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(registryOps)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(object -> null);
    }

    public static <T> Codec<Set<T>> set(Codec<T> elementType) {
        return elementType.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public static <T> void registerTypeAdapter(GsonBuilder gson, Class<T> clazz, Codec<T> codec) {
        gson.registerTypeAdapter(clazz, new JsonSerializer<T>(codec));
        gson.registerTypeAdapter(clazz, new JsonDeserializer<T>(codec));
    }

    public static <T> T getDefaultByMap(Codec<T> codec) {
        return (T)((Pair)VersionCompat.getOrThrow(codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()))).getFirst();
    }

    public static <A> MapCodec<A> assumeMapUnsafe(Codec<A> codec) {
        return MapCodec.assumeMapUnsafe(codec);
    }

    public record JsonSerializer<T>(HolderLookup.Provider registries, Codec<T> codec) implements com.google.gson.JsonSerializer<T>
    {
        public JsonSerializer(Codec<T> codec) {
            this(null, codec);
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            JsonOps ops = this.registries != null ? RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registries) : JsonOps.INSTANCE;
            return (JsonElement)VersionCompat.getOrThrow(this.codec.encodeStart((DynamicOps)ops, src));
        }
    }

    public record JsonDeserializer<T>(HolderLookup.Provider registries, Codec<T> codec) implements com.google.gson.JsonDeserializer<T>
    {
        public JsonDeserializer(Codec<T> codec) {
            this(null, codec);
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonOps ops = this.registries != null ? RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registries) : JsonOps.INSTANCE;
            return (T)((Pair)VersionCompat.getOrThrow(this.codec.decode((DynamicOps)ops, (Object)json))).getFirst();
        }
    }
}

