/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.settings;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.NameAndDescriptionItem;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.CodecUtil;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.slf4j.event.Level;

public record ModernBetaSettingsPreset(Optional<Component> presetName, Optional<Component> presetDescription, ModernBetaSettings chunkSettings, ModernBetaSettings biomeSettings, ModernBetaSettings caveBiomeSettings) implements NameAndDescriptionItem
{
    public static final Codec<ModernBetaSettingsPreset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(ModernBetaSettingsPreset::presetName), (App)ComponentSerialization.CODEC.optionalFieldOf("description").forGetter(ModernBetaSettingsPreset::presetDescription), (App)ModernBetaSettings.WORLD_CODEC.fieldOf("chunkSettings").forGetter(ModernBetaSettingsPreset::chunkSettings), (App)ModernBetaSettings.WORLD_CODEC.fieldOf("biomeSettings").forGetter(ModernBetaSettingsPreset::biomeSettings), (App)ModernBetaSettings.WORLD_CODEC.fieldOf("caveBiomeSettings").forGetter(ModernBetaSettingsPreset::caveBiomeSettings)).apply((Applicative)instance, ModernBetaSettingsPreset::new));
    public static final Codec<ModernBetaSettingsPreset> PRESET_REFERENCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("preset").forGetter(preset -> null), CodecUtil.registryLookupCodec()).apply((Applicative)instance, ModernBetaSettingsPreset::referenced));
    public static final Codec<ModernBetaSettingsPreset> SETTINGS_TEXT_CODEC = Codec.either(CODEC, PRESET_REFERENCE_CODEC).xmap(e -> (ModernBetaSettingsPreset)e.map(Function.identity(), Function.identity()), Either::left);

    public ModernBetaSettingsPreset(ModernBetaSettings chunkSettings, ModernBetaSettings biomeSettings, ModernBetaSettings caveBiomeSettings) {
        this(Optional.empty(), Optional.empty(), chunkSettings, biomeSettings, caveBiomeSettings);
    }

    public ModernBetaSettingsPreset(ResourceLocation presetId, ModernBetaSettings chunkSettings, ModernBetaSettings biomeSettings, ModernBetaSettings caveBiomeSettings) {
        this(Optional.of(ModernBetaSettingsPreset.makeTitleComponent(presetId)), Optional.of(ModernBetaSettingsPreset.makeDescriptionComponent(presetId)), chunkSettings, biomeSettings, caveBiomeSettings);
    }

    public ModernBetaSettingsPreset(HolderLookup.Provider registries, CompoundTag newChunkSettings, CompoundTag newBiomeSettings, CompoundTag newCaveBiomeSettings) {
        this(ModernBetaSettings.fromCompound(registries, newChunkSettings), ModernBetaSettings.fromCompound(registries, newBiomeSettings), ModernBetaSettings.fromCompound(registries, newCaveBiomeSettings));
    }

    public static ModernBetaSettingsPreset referenced(ResourceLocation presetId) {
        return ModernBetaSettingsPreset.referenced(presetId, null);
    }

    public static ModernBetaSettingsPreset referenced(ResourceLocation presetId, RegistryOps.RegistryInfoLookup lookup) {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder(lookup).add(SettingsComponentTypes.PRESET, presetId).build(), ModernBetaSettings.builder(lookup).add(SettingsComponentTypes.PRESET, presetId).build(), ModernBetaSettings.builder(lookup).add(SettingsComponentTypes.PRESET, presetId).build());
    }

    public static Tuple<ModernBetaSettingsPreset, Boolean> fromJson(HolderLookup.Provider registries, String jsonString) {
        if (jsonString == null || jsonString.isBlank()) {
            return new Tuple(null, (Object)false);
        }
        JsonOps ops = registries != null ? RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries) : JsonOps.INSTANCE;
        ModernBetaSettingsPreset newPreset = null;
        boolean success = false;
        try {
            Gson gson = ModernerBeta.getSettingsGson().create();
            JsonElement json = (JsonElement)gson.fromJson(jsonString, JsonElement.class);
            newPreset = json != null ? (ModernBetaSettingsPreset)((Pair)VersionCompat.getOrThrow(CODEC.decode((DynamicOps)ops, (Object)json))).getFirst() : null;
            success = true;
        }
        catch (Exception e) {
            ModernerBeta.log(Level.ERROR, "Unable to read settings JSON! Reverting to previous settings..");
            ModernerBeta.log(Level.ERROR, String.format("Reason: %s", e.getMessage()));
        }
        return new Tuple((Object)newPreset, (Object)success);
    }

    public Tuple<ModernBetaSettingsPreset, Boolean> setJson(HolderLookup.Provider registries, String stringChunk, String stringBiome, String stringCaveBiome) {
        ModernBetaSettings caveBiomeSettings;
        ModernBetaSettings biomeSettings;
        ModernBetaSettings chunkSettings;
        boolean successful = true;
        try {
            JsonOps ops = registries != null ? RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries) : JsonOps.INSTANCE;
            Gson gson = ModernerBeta.getSettingsGson().create();
            JsonElement jsonChunk = stringChunk != null && !stringChunk.isBlank() ? (JsonElement)gson.fromJson(stringChunk, JsonElement.class) : null;
            JsonElement jsonBiome = stringBiome != null && !stringBiome.isBlank() ? (JsonElement)gson.fromJson(stringBiome, JsonElement.class) : null;
            JsonElement jsonCaveBiome = stringCaveBiome != null && !stringCaveBiome.isBlank() ? (JsonElement)gson.fromJson(stringCaveBiome, JsonElement.class) : null;
            chunkSettings = jsonChunk != null ? (ModernBetaSettings)((Pair)VersionCompat.getOrThrow(ModernBetaSettings.WORLD_CODEC.decode((DynamicOps)ops, (Object)jsonChunk))).getFirst() : this.chunkSettings;
            biomeSettings = jsonBiome != null ? (ModernBetaSettings)((Pair)VersionCompat.getOrThrow(ModernBetaSettings.WORLD_CODEC.decode((DynamicOps)ops, (Object)jsonBiome))).getFirst() : this.biomeSettings;
            ModernBetaSettings modernBetaSettings = caveBiomeSettings = jsonCaveBiome != null ? (ModernBetaSettings)((Pair)VersionCompat.getOrThrow(ModernBetaSettings.WORLD_CODEC.decode((DynamicOps)ops, (Object)jsonCaveBiome))).getFirst() : this.caveBiomeSettings;
            if (chunkSettings.get(SettingsComponentTypes.PRESET) == null) {
                ModernBetaRegistries.CHUNK.get(chunkSettings.getProvider());
            }
            if (biomeSettings.get(SettingsComponentTypes.PRESET) == null) {
                ModernBetaRegistries.BIOME.get(biomeSettings.getProvider());
            }
            if (caveBiomeSettings.get(SettingsComponentTypes.PRESET) == null) {
                ModernBetaRegistries.CAVE_BIOME.get(caveBiomeSettings.getProvider());
            }
        }
        catch (Exception e) {
            ModernerBeta.log(Level.ERROR, "Unable to read settings JSON! Reverting to previous settings..");
            ModernerBeta.log(Level.ERROR, String.format("Reason: %s", e.getMessage()));
            successful = false;
            chunkSettings = this.chunkSettings;
            biomeSettings = this.biomeSettings;
            caveBiomeSettings = this.caveBiomeSettings;
        }
        return new Tuple((Object)new ModernBetaSettingsPreset(chunkSettings, biomeSettings, caveBiomeSettings), (Object)successful);
    }

    public Tuple<ModernBetaSettingsPreset, Boolean> setNbt(HolderLookup.Provider registries, CompoundTag nbtChunk, CompoundTag nbtBiome, CompoundTag nbtCaveBiome) {
        HolderLookup.RegistryLookup presetRegistry = registries.lookupOrThrow(ModernBetaResourceKeys.SETTINGS_PRESET);
        ModernBetaSettings chunkSettings = this.chunkSettings;
        ModernBetaSettings biomeSettings = this.biomeSettings;
        ModernBetaSettings caveBiomeSettings = this.caveBiomeSettings;
        boolean successful = true;
        try {
            if (nbtChunk != null) {
                chunkSettings = ModernBetaSettings.fromCompound(registries, nbtChunk);
                if (presetRegistry != null) {
                    chunkSettings = this.chunkSettings.getDifference(chunkSettings, (HolderGetter<ModernBetaSettingsPreset>)presetRegistry, ModernBetaSettingsPreset::chunkSettings);
                }
            }
            if (nbtBiome != null) {
                biomeSettings = ModernBetaSettings.fromCompound(registries, nbtBiome);
                if (presetRegistry != null) {
                    biomeSettings = this.biomeSettings.getDifference(biomeSettings, (HolderGetter<ModernBetaSettingsPreset>)presetRegistry, ModernBetaSettingsPreset::biomeSettings);
                }
            }
            if (nbtCaveBiome != null) {
                caveBiomeSettings = ModernBetaSettings.fromCompound(registries, nbtCaveBiome);
                if (presetRegistry != null) {
                    caveBiomeSettings = this.caveBiomeSettings.getDifference(caveBiomeSettings, (HolderGetter<ModernBetaSettingsPreset>)presetRegistry, ModernBetaSettingsPreset::caveBiomeSettings);
                }
            }
            if (chunkSettings.get(SettingsComponentTypes.PRESET) == null) {
                ModernBetaRegistries.CHUNK.get(chunkSettings.getProvider());
            }
            if (biomeSettings.get(SettingsComponentTypes.PRESET) == null) {
                ModernBetaRegistries.BIOME.get(biomeSettings.getProvider());
            }
            if (caveBiomeSettings.get(SettingsComponentTypes.PRESET) == null) {
                ModernBetaRegistries.CAVE_BIOME.get(caveBiomeSettings.getProvider());
            }
        }
        catch (Exception e) {
            ModernerBeta.log(Level.ERROR, "Unable to read settings NBT! Reverting to previous settings..");
            ModernerBeta.log(Level.ERROR, String.format("Reason: %s", e.getMessage()));
            successful = false;
            chunkSettings = this.chunkSettings;
            biomeSettings = this.biomeSettings;
            caveBiomeSettings = this.caveBiomeSettings;
        }
        return new Tuple((Object)new ModernBetaSettingsPreset(chunkSettings, biomeSettings, caveBiomeSettings), (Object)successful);
    }

    public static Optional<ModernBetaSettingsPreset> getPreset(ResourceLocation presetId, HolderGetter<ModernBetaSettingsPreset> presetRegistry) {
        Optional preset;
        if (presetId == null) {
            return Optional.empty();
        }
        if (presetId.equals((Object)ModernBetaSettings.DEFAULT_PRESET_ID)) {
            presetId = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).defaultSettingsPreset();
        }
        if ((preset = presetRegistry.get(ResourceKey.create(ModernBetaResourceKeys.SETTINGS_PRESET, (ResourceLocation)presetId))).isEmpty()) {
            ModernerBeta.log(Level.WARN, "Attempted to get Modern Beta preset \"" + String.valueOf(presetId) + "\", which is not registered.");
            return Optional.empty();
        }
        Holder.Reference reference = (Holder.Reference)preset.get();
        if (!reference.isBound() && ModernerBeta.GENERATING_DATA) {
            return Optional.empty();
        }
        return Optional.of((ModernBetaSettingsPreset)reference.value());
    }

    public ModernBetaSettingsPreset mapped(HolderGetter<ModernBetaSettingsPreset> presetRegistry) {
        return new ModernBetaSettingsPreset(this.chunkSettings.mapPreset(presetRegistry, ModernBetaSettingsPreset::chunkSettings), this.biomeSettings.mapPreset(presetRegistry, ModernBetaSettingsPreset::biomeSettings), this.caveBiomeSettings.mapPreset(presetRegistry, ModernBetaSettingsPreset::caveBiomeSettings));
    }

    public ModernBetaSettingsPreset withNameAndDesc(Component title, Component description) {
        return new ModernBetaSettingsPreset(Optional.of(title), Optional.of(description), this.chunkSettings, this.biomeSettings, this.caveBiomeSettings);
    }

    public ModernBetaSettingsPreset withNameAndDesc(ResourceLocation id) {
        return this.withNameAndDesc(ModernBetaSettingsPreset.makeTitleComponent(id), ModernBetaSettingsPreset.makeDescriptionComponent(id));
    }

    public List<ModernBetaSettings> asList() {
        return List.of(this.chunkSettings, this.biomeSettings, this.caveBiomeSettings);
    }

    @Override
    public Component makeOrGetTitleComponent(ResourceLocation fallbackId) {
        return this.presetName.orElseGet(() -> ModernBetaSettingsPreset.makeTitleComponent(fallbackId));
    }

    @Override
    public Component makeOrGetDescriptionComponent(ResourceLocation fallbackId) {
        return this.presetDescription.orElseGet(() -> ModernBetaSettingsPreset.makeDescriptionComponent(fallbackId));
    }

    private static Component makeTitleComponent(ResourceLocation id) {
        return Component.translatable((String)("createWorld.customize.modern_beta.preset.name." + id.toLanguageKey())).withStyle(ChatFormatting.YELLOW);
    }

    private static Component makeDescriptionComponent(ResourceLocation id) {
        return Component.translatable((String)("createWorld.customize.modern_beta.preset.desc." + id.toLanguageKey()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ModernBetaSettingsPreset.class) {
            return false;
        }
        ModernBetaSettingsPreset other = (ModernBetaSettingsPreset)obj;
        return this.chunkSettings.equals(other.chunkSettings) && this.biomeSettings.equals(other.biomeSettings) && this.caveBiomeSettings.equals(other.caveBiomeSettings);
    }
}

