/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.network;

import mod.bluestaggo.modernerbeta.api.level.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSamplerSky;
import mod.bluestaggo.modernerbeta.api.level.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.client.color.BlockColorSampler;
import mod.bluestaggo.modernerbeta.client.color.SkyColorSampler;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaLevel;
import mod.bluestaggo.modernerbeta.network.BiomeProviderInfoPayload;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class S2CPacketHandlers {
    public static void onBiomeProviderInfo(Level level, BiomeProviderInfoPayload payload) {
        BlockColorSampler.INSTANCE.setClimateSampler(null);
        SkyColorSampler.INSTANCE.setClimateSampler(null);
        if (payload.isModernBetaLevel()) {
            if (level != null) {
                ((ModernBetaLevel)level).modernerBeta$setModded(true);
            }
            if (!payload.hasBiomeProvider()) {
                return;
            }
            HolderLookup.RegistryLookup biomeRegistry = level.registryAccess().lookupOrThrow(Registries.BIOME);
            BiomeProviderType providerCreator = (BiomeProviderType)ModernBetaRegistries.BIOME.get(payload.providerId().orElseThrow());
            Object provider = providerCreator.apply(ModernBetaSettings.fromCompound((HolderLookup.Provider)level.registryAccess(), payload.settings().orElseThrow()), (HolderGetter<Biome>)biomeRegistry, payload.seed().orElseThrow());
            ((ModernBetaLevel)level).modernerBeta$setTemperatureHeightScaling(((BiomeProvider)provider).getTemperatureHeightScaling());
            if (provider instanceof ClimateSampler) {
                ClimateSampler climateSampler = (ClimateSampler)provider;
                BlockColorSampler.INSTANCE.setClimateSampler(climateSampler);
                ((ModernBetaLevel)level).modernerBeta$setClimateSampler(climateSampler);
            }
            if (provider instanceof ClimateSamplerSky) {
                ClimateSamplerSky climateSamplerSky = (ClimateSamplerSky)provider;
                SkyColorSampler.INSTANCE.setClimateSampler(climateSamplerSky);
            }
        } else if (level != null) {
            ((ModernBetaLevel)level).modernerBeta$setModded(false);
        }
    }
}

