/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.client.FogUtils;
import mod.bluestaggo.modernerbeta.client.color.BlockColorSampler;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaLevel;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @Unique
    private static final String GET_FOG_COLOR_METHOD = "setupColor";
    @Unique
    private static Vec3 modernBeta_pos;
    @Unique
    private static int modernBeta_renderDistance;
    @Unique
    private static float modernBeta_fogWeight;
    @Unique
    private static boolean modernBeta_isModernBetaLevel;

    @WrapOperation(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getWaterFogColor()I")})
    private static int modifyWaterFogColor(Biome instance, Operation<Integer> original) {
        if (BlockColorSampler.INSTANCE.useWaterColor()) {
            int x = (int)modernBeta_pos.x();
            int z = (int)modernBeta_pos.z();
            Clime clime = BlockColorSampler.INSTANCE.getClimateSampler().sample(x, z);
            return BlockColorSampler.INSTANCE.colormapUnderwater.getColor(clime.temp(), clime.rain());
        }
        return (Integer)original.call(new Object[]{instance});
    }

    @Inject(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="HEAD")})
    private static void captureVars(Camera camera, float tickDelta, ClientLevel world, int renderDistance, float skyDarkness, CallbackInfo ci) {
        modernBeta_pos = camera.getPosition();
        if (modernBeta_renderDistance != renderDistance) {
            modernBeta_renderDistance = renderDistance;
            modernBeta_fogWeight = FogUtils.calculateFogWeight(renderDistance);
        }
        modernBeta_isModernBetaLevel = ((ModernBetaLevel)world).modernerBeta$isModded();
    }

    @WrapOperation(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="INVOKE", target="Ljava/lang/Math;pow(DD)D", remap=false)})
    private static double modifyFogWeighting(double a, double b, Operation<Double> original) {
        double baseWeight = modernBeta_isModernBetaLevel && ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_MISCELLANEOUS).oldFogColorWeighting() ? (double)modernBeta_fogWeight : a;
        return (Double)original.call(new Object[]{baseWeight, b});
    }

    static {
        modernBeta_renderDistance = 16;
        modernBeta_fogWeight = FogUtils.calculateFogWeight(16);
        modernBeta_isModernBetaLevel = false;
    }
}

