/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderFinite;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.chunk.provider.ChunkProviderFinite2D;
import mod.bluestaggo.modernerbeta.level.chunk.provider.indev.IndevTheme;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.storage.ServerLevelData;
import org.slf4j.event.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Inject(method={"setInitialSpawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/ServerLevelData;ZZ)V"}, at={@At(value="RETURN")})
    private static void injectSetInitialSpawn(ServerLevel level, ServerLevelData levelData, boolean bonusChest, boolean debugWorld, CallbackInfo ci) {
        ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            levelData.setSpawn(levelData.getSpawnPos(), -90.0f);
        }
    }

    @WrapOperation(method={"setInitialSpawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/storage/ServerLevelData;ZZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/PlayerRespawnLogic;getSpawnPosInChunk(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/core/BlockPos;")})
    private static BlockPos redirectPlayerSpawnFinder(ServerLevel level, ChunkPos chunkPos, Operation<BlockPos> original) {
        ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
        if (chunkGenerator instanceof ModernBetaChunkGenerator) {
            ModernBetaChunkGenerator modernBetaChunkGenerator = (ModernBetaChunkGenerator)chunkGenerator;
            ChunkProvider chunkProvider = modernBetaChunkGenerator.getChunkProvider();
            ((GameRules.IntegerValue)level.getGameRules().getRule(GameRules.RULE_SPAWN_RADIUS)).set(0, level.getServer());
            BlockPos spawnPos = chunkProvider.getSpawnLocator().locateSpawn((LevelHeightAccessor)level).orElseGet(() -> (BlockPos)original.call(new Object[]{level, chunkPos}));
            if (spawnPos != null && ModernerBeta.DEV_ENV) {
                int x = spawnPos.getX();
                int y = spawnPos.getY();
                int z = spawnPos.getZ();
                ModernerBeta.log(Level.INFO, String.format("Spawning at %d/%d/%d", x, y, z));
            }
            if (spawnPos != null && chunkProvider instanceof ChunkProviderFinite2D) {
                ChunkProviderFinite2D chunkProviderIndev = (ChunkProviderFinite2D)chunkProvider;
                chunkProviderIndev.generateIndevHouse(level, spawnPos);
                MinecraftServerMixin.setIndevProperties(level, chunkProviderIndev.getLevelTheme());
            }
            if (chunkProvider instanceof ChunkProviderFinite) {
                ChunkProviderFinite.resetPhase();
            }
            return spawnPos;
        }
        return (BlockPos)original.call(new Object[]{level, chunkPos});
    }

    @Unique
    private static void setIndevProperties(ServerLevel level, IndevTheme theme) {
        switch (theme) {
            case HELL: {
                MinecraftServerMixin.disableWeatherCycle(level);
                MinecraftServerMixin.disableDayCycle(level);
                level.setDayTime(18000L);
                break;
            }
            case PARADISE: {
                MinecraftServerMixin.disableWeatherCycle(level);
                MinecraftServerMixin.disableDayCycle(level);
                level.setDayTime(6000L);
                break;
            }
            case WOODS: {
                MinecraftServerMixin.disableWeatherCycle(level);
                level.setWeatherParameters(0, Integer.MAX_VALUE, true, false);
                break;
            }
        }
    }

    @Unique
    private static void disableWeatherCycle(ServerLevel level) {
        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, null);
    }

    @Unique
    private static void disableDayCycle(ServerLevel level) {
        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(false, null);
    }
}

