/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.structure;

import mod.bluestaggo.modernerbeta.level.structure.ModernBetaStructurePieceTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class OceanShrineStructurePiece
extends TemplateStructurePiece {
    public OceanShrineStructurePiece(StructureTemplateManager manager, BlockPos pos, ResourceLocation template, Rotation rot) {
        super(ModernBetaStructurePieceTypes.OCEAN_SHRINE, 0, manager, template, template.toString(), OceanShrineStructurePiece.getPlacementData(rot), pos);
    }

    public OceanShrineStructurePiece(StructureTemplateManager manager, CompoundTag tag) {
        super(ModernBetaStructurePieceTypes.OCEAN_SHRINE, tag, manager, identifier -> OceanShrineStructurePiece.getPlacementData(Rotation.valueOf((String)tag.getString("Rot"))));
    }

    private static StructurePlaceSettings getPlacementData(Rotation rotation) {
        return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbtCompound) {
        super.addAdditionalSaveData(context, nbtCompound);
        nbtCompound.putString("Rot", this.placeSettings.getRotation().name());
    }

    protected void handleDataMarker(String metadata, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox boundingBox) {
        if (metadata.equals("chest")) {
            level.setBlock(pos, (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).is(FluidTags.WATER))), 2);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                chestBlockEntity.setLootTable(BuiltInLootTables.BURIED_TREASURE, random.nextLong());
            }
        }
    }

    public void postProcess(WorldGenLevel level, StructureManager manager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        this.placeSettings.clearProcessors().addProcessor((StructureProcessor)new BlockRotProcessor(1.0f)).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        super.postProcess(level, manager, chunkGenerator, random, boundingBox, chunkPos, blockPos);
    }
}

