/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.structure;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.level.structure.ModernBetaStructureTypes;
import mod.bluestaggo.modernerbeta.level.structure.OceanShrineStructurePiece;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class OceanShrineStructure
extends Structure {
    public static final MapCodec<OceanShrineStructure> CODEC = OceanShrineStructure.simpleCodec(OceanShrineStructure::new);
    private static final ResourceLocation SHRINE_BASE = ModernerBeta.createId("ocean_shrine/base");

    public OceanShrineStructure(Structure.StructureSettings config) {
        super(config);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int x = context.chunkPos().getMinBlockX();
        int z = context.chunkPos().getMinBlockZ();
        int y = context.chunkGenerator().getFirstOccupiedHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        BlockPos pos = new BlockPos(x, y, z);
        Rotation rot = Rotation.getRandom((RandomSource)context.random());
        return Optional.of(new Structure.GenerationStub(pos, collector -> collector.addPiece((StructurePiece)new OceanShrineStructurePiece(context.structureTemplateManager(), pos, SHRINE_BASE, rot))));
    }

    public StructureType<?> type() {
        return ModernBetaStructureTypes.OCEAN_SHRINE;
    }
}

