/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.level.chunk.provider;

import java.util.Random;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.api.level.chunk.ChunkProviderForcedHeight;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceBlocks;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.level.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.level.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.biome.provider.BiomeProviderBeta;
import mod.bluestaggo.modernerbeta.level.biome.provider.BiomeProviderPE;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.spawn.SpawnLocatorBeta;
import mod.bluestaggo.modernerbeta.level.spawn.SpawnLocatorPE;
import mod.bluestaggo.modernerbeta.level.spawn.SpawnLocatorRelease;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.Noise3DSettings;
import mod.bluestaggo.modernerbeta.settings.component.NoiseLandmass;
import mod.bluestaggo.modernerbeta.settings.component.PerlinNoiseSettings;
import mod.bluestaggo.modernerbeta.settings.component.SurfaceProperties;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.util.noise.SimplexOctaveNoise;
import mod.bluestaggo.modernerbeta.util.random.mersenne.MTRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;

public class ChunkProviderNoise3D
extends ChunkProviderForcedHeight {
    private final Noise3DSettings noise3DSettings;
    private final NoiseLandmass noiseLandmass;
    private final SurfaceProperties surfaceProperties;
    private final boolean forcedBiomeHeightEnabled;
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise beachOctaveNoise;
    private final PerlinOctaveNoise surfacePerlinOctaveNoise;
    private final SimplexOctaveNoise surfaceSimplexOctaveNoise;
    private final PerlinOctaveNoise scaleOctaveNoise;
    private final PerlinOctaveNoise depthOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;
    private final ClimateSampler climateSampler;

    public ChunkProviderNoise3D(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        ClimateSampler climateSampler;
        PerlinNoiseSettings perlinSettings = this.getChunkSettings().getOrDefault(SettingsComponentTypes.PERLIN_NOISE_SETTINGS);
        this.noise3DSettings = this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_3D_SETTINGS);
        this.noiseLandmass = this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_LANDMASS);
        this.surfaceProperties = this.getChunkSettings().getOrDefault(SettingsComponentTypes.SURFACE_PROPERTIES);
        this.forcedBiomeHeightEnabled = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FORCED_BIOME_HEIGHT).enabled();
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, perlinSettings);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, perlinSettings);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, perlinSettings);
        PerlinOctaveNoise perlinOctaveNoise = this.beachOctaveNoise = this.surfaceProperties.enableBeaches() ? new PerlinOctaveNoise(this.random, 4, perlinSettings) : null;
        if (this.noise3DSettings.simplexSurfaceNoise()) {
            this.surfacePerlinOctaveNoise = null;
            this.surfaceSimplexOctaveNoise = new SimplexOctaveNoise(this.random, 4);
        } else {
            this.surfacePerlinOctaveNoise = new PerlinOctaveNoise(this.random, 4, perlinSettings);
            this.surfaceSimplexOctaveNoise = null;
        }
        this.scaleOctaveNoise = this.noiseLandmass.scale().enabled() ? new PerlinOctaveNoise(this.random, 10, perlinSettings) : null;
        this.depthOctaveNoise = this.noiseLandmass.depth().enabled() ? new PerlinOctaveNoise(this.random, 16, perlinSettings) : null;
        if (!this.noiseLandmass.scale().enabled() && !this.noiseLandmass.depth().enabled()) {
            new PerlinOctaveNoise(this.random, this.noiseScale.forestNoiseOctaves(), perlinSettings);
        }
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, this.noiseScale.forestNoiseOctaves(), perlinSettings);
        if (!this.noise3DSettings.climateHeightScaling()) {
            climateSampler = null;
        } else {
            ModernBetaBiomeSource biomeSource;
            Object object = this.chunkGenerator.getBiomeSource();
            if (object instanceof ModernBetaBiomeSource && (object = (biomeSource = (ModernBetaBiomeSource)((Object)object)).getBiomeProvider()) instanceof ClimateSampler) {
                ClimateSampler climateSampler2 = (ClimateSampler)object;
                climateSampler = climateSampler2;
            } else {
                climateSampler = this.noise3DSettings.pocketEditionRng() ? new BiomeProviderPE(ModernBetaSettings.empty(), null, seed) : new BiomeProviderBeta(ModernBetaSettings.empty(), null, seed);
            }
        }
        this.climateSampler = climateSampler;
    }

    @Override
    public SpawnLocator getSpawnLocator() {
        if (this.beachOctaveNoise != null) {
            if (this.surfaceProperties.generateBeaches()) {
                if (this.noise3DSettings.pocketEditionRng()) {
                    return new SpawnLocatorPE(this, this.beachOctaveNoise, this.createRandom(this.seed));
                }
                return new SpawnLocatorBeta(this, this.beachOctaveNoise, this.createRandom(this.seed));
            }
            return SpawnLocator.DEFAULT;
        }
        return new SpawnLocatorRelease(this, this.createRandom(this.seed));
    }

    @Override
    public void provideSurface(WorldGenRegion region, StructureManager structureAccessor, ChunkAccess chunk, ModernBetaBiomeSource biomeSource, RandomState noiseConfig) {
        ChunkPos chunkPos = chunk.getPos();
        int chunkX = chunkPos.x;
        int chunkZ = chunkPos.z;
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        int seaLevel = this.getSeaLevel();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Aquifer aquiferSampler = this.getAquiferSampler(chunk, noiseConfig);
        ChunkHeightmap heightmapChunk = this.getChunkHeightmap((LevelHeightAccessor)region, chunkX, chunkZ);
        SimpleNoisePos noisePos = new SimpleNoisePos();
        boolean generateBeaches = this.surfaceProperties.generateBeaches();
        float sandScale = this.surfaceProperties.sandBeachScale();
        float gravelScale = this.surfaceProperties.gravelBeachScale();
        float surfaceScale = this.surfaceProperties.surfaceNoiseScale();
        boolean initBeachArrays = this.surfaceProperties.enableBeaches() && generateBeaches && this.noise3DSettings.arraySurfaceNoise();
        double[] sandNoise = initBeachArrays ? this.beachOctaveNoise.sampleArray(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, sandScale, sandScale, 1.0) : null;
        double[] gravelNoise = initBeachArrays ? this.beachOctaveNoise.sampleArray(chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, gravelScale, 1.0, gravelScale) : null;
        double[] surfaceNoise = this.surfacePerlinOctaveNoise != null && this.noise3DSettings.arraySurfaceNoise() ? this.surfacePerlinOctaveNoise.sampleArray(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, surfaceScale, surfaceScale, surfaceScale) : null;
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                boolean genGravelBeach;
                double sandValue;
                int noiseCoord;
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG).getFirstAvailable(localX, localZ) - 1;
                int surfaceMinY = heightmapChunk != null ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) - 8 : this.worldMinY;
                int n = noiseCoord = this.surfaceProperties.flipNoiseCoordinates() ? localX + localZ * 16 : localZ + localX * 16;
                double d = generateBeaches && sandNoise != null ? sandNoise[noiseCoord] : (sandValue = this.beachOctaveNoise != null ? this.beachOctaveNoise.sample((float)x * sandScale, (float)z * sandScale, 0.0) : Double.NEGATIVE_INFINITY);
                double gravelValue = generateBeaches && gravelNoise != null ? gravelNoise[noiseCoord] : (this.beachOctaveNoise != null ? this.beachOctaveNoise.sample((float)z * gravelScale, 109.0134, (float)x * gravelScale) : Double.NEGATIVE_INFINITY);
                boolean genSandBeach = generateBeaches && sandValue + rand.nextDouble() * 0.2 > 0.0;
                boolean bl = genGravelBeach = generateBeaches && gravelValue + rand.nextDouble() * 0.2 > 3.0;
                double surfaceSample = surfaceNoise != null ? surfaceNoise[noiseCoord] : (this.surfaceSimplexOctaveNoise != null ? this.surfaceSimplexOctaveNoise.sample(x, z, surfaceScale, 1.0) : (this.surfacePerlinOctaveNoise != null ? this.surfacePerlinOctaveNoise.sample(x, z, surfaceScale) : 0.0));
                int surfaceDepth = (int)(surfaceSample / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                if (!this.surfaceProperties.erosion() && surfaceDepth < 1) {
                    surfaceDepth = 1;
                }
                int runDepth = -1;
                Holder<Biome> biome = biomeSource.getBiomeForSurfaceGen(region, (BlockPos)pos.set(x, surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                BlockState topBlock = surfaceConfig.normal().topBlock();
                BlockState fillerBlock = surfaceConfig.normal().fillerBlock();
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    pos.set(localX, y, localZ);
                    BlockState blockState = chunk.getBlockState((BlockPos)pos);
                    if (this.surfaceProperties.generateBedrock()) {
                        int bedrockOffset;
                        int n2 = bedrockOffset = this.surfaceProperties.bedrockHoles() ? rand.nextInt(6) - 1 : rand.nextInt(5);
                        if (y <= this.bedrockFloor + bedrockOffset) {
                            VersionCompat.setBlockState(chunk, (BlockPos)pos, BlockStates.BEDROCK);
                            continue;
                        }
                    }
                    if (y < surfaceMinY) continue;
                    if (blockState.isAir()) {
                        runDepth = -1;
                        continue;
                    }
                    if (!blockState.is(this.defaultBlock.getBlock())) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                            topBlock = surfaceConfig.normal().topBlock();
                            fillerBlock = surfaceConfig.normal().fillerBlock();
                            if (genGravelBeach) {
                                topBlock = surfaceConfig.beachGravel().topBlock();
                                fillerBlock = surfaceConfig.beachGravel().fillerBlock();
                            }
                            if (genSandBeach) {
                                topBlock = surfaceConfig.beachSand().topBlock();
                                fillerBlock = surfaceConfig.beachSand().fillerBlock();
                            }
                        }
                        runDepth = surfaceDepth;
                        if (this.surfaceProperties.generateLiquids() && y < seaLevel && topBlock.isAir()) {
                            BlockState fluidBlock = aquiferSampler.computeSubstance((DensityFunction.FunctionContext)noisePos.set(x, y, z), 0.0);
                            boolean isAir = fluidBlock == null;
                            topBlock = isAir ? BlockStates.AIR : fluidBlock;
                            this.scheduleFluidTick(chunk, aquiferSampler, (BlockPos)pos, topBlock);
                        }
                        if (y >= seaLevel - 1 || y < seaLevel - 1 && chunk.getBlockState(pos.above()).isAir()) {
                            blockState = topBlock;
                        } else if (this.surfaceProperties.gravelOceanBed() && y < seaLevel - 7 - surfaceDepth) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = BlockStates.STONE;
                            blockState = BlockStates.GRAVEL;
                        } else {
                            blockState = fillerBlock;
                        }
                        VersionCompat.setBlockState(chunk, (BlockPos)pos, blockState);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, fillerBlock);
                    if (--runDepth == 0 && fillerBlock.is(Blocks.SAND)) {
                        runDepth = rand.nextInt(4);
                        fillerBlock = BlockStates.SANDSTONE;
                    }
                    if (runDepth != 0 || !fillerBlock.is(Blocks.RED_SAND)) continue;
                    runDepth = rand.nextInt(4);
                    fillerBlock = BlockStates.RED_SANDSTONE;
                }
            }
        }
    }

    @Override
    public void provideSurfaceExtra(WorldGenRegion region, StructureManager structureAccessor, ChunkAccess chunk, ModernBetaBiomeSource biomeSource, RandomState noiseConfig) {
        ChunkPos chunkPos = chunk.getPos();
        int chunkX = chunkPos.x;
        int chunkZ = chunkPos.z;
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        int seaLevel = this.getSeaLevel();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        ChunkHeightmap heightmapChunk = this.hasNoisePostProcessor() ? this.getChunkHeightmap((LevelHeightAccessor)region, chunkX, chunkZ) : null;
        boolean generateBeaches = this.surfaceProperties.generateBeaches();
        float sandScale = this.surfaceProperties.sandBeachScale();
        float gravelScale = this.surfaceProperties.gravelBeachScale();
        float surfaceScale = this.surfaceProperties.surfaceNoiseScale();
        boolean initBeachArrays = this.surfaceProperties.enableBeaches() && generateBeaches && this.noise3DSettings.arraySurfaceNoise();
        double[] sandNoise = initBeachArrays ? this.beachOctaveNoise.sampleArray(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, sandScale, sandScale, 1.0) : null;
        double[] gravelNoise = initBeachArrays ? this.beachOctaveNoise.sampleArray(chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, gravelScale, 1.0, gravelScale) : null;
        double[] surfaceNoise = this.surfacePerlinOctaveNoise != null && this.noise3DSettings.arraySurfaceNoise() ? this.surfacePerlinOctaveNoise.sampleArray(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, surfaceScale, surfaceScale, surfaceScale) : null;
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                boolean genGravelBeach;
                double sandValue;
                int noiseCoord;
                pos.set(localX, 0, localZ);
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = heightmapChunk != null ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) : chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG).getFirstAvailable(localX, localZ);
                --surfaceTopY;
                int n = noiseCoord = this.surfaceProperties.flipNoiseCoordinates() ? localX + localZ * 16 : localZ + localX * 16;
                double d = generateBeaches && sandNoise != null ? sandNoise[noiseCoord] : (sandValue = this.beachOctaveNoise != null ? this.beachOctaveNoise.sample((float)x * sandScale, (float)z * sandScale, 0.0) : Double.NEGATIVE_INFINITY);
                double gravelValue = generateBeaches && gravelNoise != null ? gravelNoise[noiseCoord] : (this.beachOctaveNoise != null ? this.beachOctaveNoise.sample((float)z * gravelScale, 109.0134, (float)x * gravelScale) : Double.NEGATIVE_INFINITY);
                boolean genSandBeach = generateBeaches && sandValue + rand.nextDouble() * 0.2 > 0.0;
                boolean bl = genGravelBeach = generateBeaches && gravelValue + rand.nextDouble() * 0.2 > 3.0;
                double surfaceSample = !this.surfaceProperties.erosion() ? 1.0 : (surfaceNoise != null ? surfaceNoise[noiseCoord] : (this.surfaceSimplexOctaveNoise != null ? this.surfaceSimplexOctaveNoise.sample(x, z, surfaceScale, 1.0) : (this.surfacePerlinOctaveNoise != null ? this.surfacePerlinOctaveNoise.sample(x, z, surfaceScale) : 0.0)));
                int surfaceDepth = (int)(surfaceSample / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                Holder<Biome> biome = biomeSource.getBiomeForSurfaceGen(region, (BlockPos)pos.set(x, surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                int y = surfaceTopY;
                pos.setY(y);
                if (this.isBlockSuitableForSurface(chunk.getBlockState((BlockPos)pos))) {
                    if (surfaceDepth <= 0) {
                        VersionCompat.setBlockState(chunk, (BlockPos)pos, y < seaLevel ? this.defaultBlock : BlockStates.AIR);
                        pos.setY(--y);
                        while (this.isBlockSuitableForSurface(chunk.getBlockState((BlockPos)pos))) {
                            VersionCompat.setBlockState(chunk, (BlockPos)pos, this.defaultBlock);
                            pos.setY(--y);
                        }
                    } else if (surfaceTopY >= seaLevel - 4 && surfaceTopY < seaLevel + 1) {
                        SurfaceBlocks beach;
                        SurfaceBlocks surfaceBlocks = genSandBeach ? surfaceConfig.beachSand() : (beach = genGravelBeach ? surfaceConfig.beachGravel() : null);
                        if (beach != null) {
                            if (beach.topBlock().isAir() && y < seaLevel) {
                                VersionCompat.setBlockState(chunk, (BlockPos)pos, this.defaultFluid);
                            } else {
                                VersionCompat.setBlockState(chunk, (BlockPos)pos, beach.topBlock());
                            }
                            pos.setY(--y);
                            while (this.isBlockSuitableForSurface(chunk.getBlockState((BlockPos)pos))) {
                                VersionCompat.setBlockState(chunk, (BlockPos)pos, beach.fillerBlock());
                                pos.setY(--y);
                            }
                        }
                    }
                }
                if (!this.surfaceProperties.generateBedrock()) continue;
                for (y = this.bedrockFloor; y < this.bedrockFloor + 5; ++y) {
                    int bedrockOffset;
                    int n2 = bedrockOffset = this.surfaceProperties.bedrockHoles() ? rand.nextInt(6) - 1 : rand.nextInt(5);
                    if (y > this.bedrockFloor + bedrockOffset) continue;
                    pos.setY(y);
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, BlockStates.BEDROCK);
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] primaryBuffer, double[] heightmapBuffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        double depth;
        double scale;
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double islandOffset = this.getIslandOffset(noiseX, noiseZ);
        double depthNoiseScaleX = this.noiseScale.depthNoiseX();
        double depthNoiseScaleZ = this.noiseScale.depthNoiseZ();
        double coordinateScale = this.noiseScale.coordinate();
        double heightScale = this.noiseScale.height();
        double mainNoiseScaleX = this.noiseScale.mainNoiseX();
        double mainNoiseScaleY = this.noiseScale.mainNoiseY();
        double mainNoiseScaleZ = this.noiseScale.mainNoiseZ();
        double lowerLimitScale = this.noiseScale.lowerLimit();
        double upperLimitScale = this.noiseScale.upperLimit();
        double baseSize = this.noiseScale.baseSize();
        double heightStretch = this.noiseScale.stretchY();
        boolean oldInfdev = this.noise3DSettings.oldInfdevTerrainNoise();
        double d = this.scaleOctaveNoise != null && this.noiseLandmass.scale().sample() ? ((this.noiseLandmass.alphaSampling() ? this.scaleOctaveNoise.sample(noiseX, 0.0, noiseZ, this.noiseLandmass.scale().variation(), 0.0, this.noiseLandmass.scale().variation()) : this.scaleOctaveNoise.sampleXZ(noiseX, noiseZ, this.noiseLandmass.scale().variation(), this.noiseLandmass.scale().variation())) + 256.0) / 512.0 : (scale = 1.0);
        double d2 = this.depthOctaveNoise != null && this.noiseLandmass.depth().sample() ? (this.noiseLandmass.alphaSampling() ? this.depthOctaveNoise.sample(noiseX, 0.0, noiseZ, depthNoiseScaleX, 0.0, depthNoiseScaleZ) : this.depthOctaveNoise.sampleXZ(noiseX, noiseZ, depthNoiseScaleX, depthNoiseScaleZ)) : (depth = 0.0);
        if (this.noiseLandmass.depth().sample()) {
            if ((depth /= 8000.0) < 0.0) {
                depth = -depth * (double)this.noiseLandmass.depth().negativeInfluence();
            }
            if ((depth = depth * (double)this.noiseLandmass.depth().stretch() + (double)this.noiseLandmass.depth().offset()) < 0.0) {
                depth = Math.max(depth / (double)this.noiseLandmass.depth().negativeDampening(), (double)this.noiseLandmass.depth().minValue());
                if (this.noiseLandmass.depth().negativeFlattening()) {
                    scale = 0.0;
                }
            } else {
                depth = Math.min(depth / (double)this.noiseLandmass.depth().positiveDampening(), (double)this.noiseLandmass.depth().maxValue());
            }
        }
        double modScale = 0.0;
        double modDepth = 0.0;
        if (this.forcedBiomeHeightEnabled) {
            HeightConfig heightConfig = this.getHeightConfigAt(noiseX, noiseZ);
            modScale = heightConfig.scale();
            modDepth = heightConfig.depth();
        }
        if (this.noise3DSettings.climateHeightScaling()) {
            int horizNoiseResolution = 16 / (this.noiseSizeX + 1);
            int climeX = startNoiseX / this.noiseSizeX * 16 + localNoiseX * horizNoiseResolution + horizNoiseResolution / 2;
            int climeZ = startNoiseZ / this.noiseSizeZ * 16 + localNoiseZ * horizNoiseResolution + horizNoiseResolution / 2;
            Clime clime = this.climateSampler.sample(climeX, climeZ);
            double temp = clime.temp();
            double rain = clime.rain() * temp;
            rain = 1.0 - rain;
            rain *= rain;
            rain *= rain;
            rain = 1.0 - rain;
            scale *= rain;
        }
        if ((scale = modScale + scale * (double)this.noiseLandmass.scale().influence()) < 0.0 && !this.noise3DSettings.monoliths()) {
            scale = 0.0;
        }
        if (!this.forcedBiomeHeightEnabled && this.noiseLandmass.scale().sample()) {
            scale = Math.min(scale, 1.0);
        }
        scale += (double)this.noiseLandmass.scale().offset();
        depth = modDepth + depth * (double)this.noiseLandmass.depth().influence();
        depth *= baseSize / 8.0;
        depth = baseSize + depth * 4.0;
        for (int y = 0; y < primaryBuffer.length; ++y) {
            double density;
            int noiseY = y + this.noiseMinY;
            double densityOffset = this.getOffset(noiseY, heightStretch, depth, scale);
            double mainNoise = this.mainOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ) / (double)this.noiseScale.limitBlending();
            if (!oldInfdev) {
                mainNoise += 1.0;
            }
            mainNoise /= 2.0;
            double d3 = oldInfdev ? -1.0 : 0.0;
            if (mainNoise < d3) {
                density = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
                density -= densityOffset;
                density += islandOffset;
                if (oldInfdev) {
                    density = Mth.clamp((double)density, (double)-10.0, (double)10.0);
                }
            } else if (mainNoise > 1.0) {
                density = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
                density -= densityOffset;
                density += islandOffset;
                if (oldInfdev) {
                    density = Mth.clamp((double)density, (double)-10.0, (double)10.0);
                }
            } else {
                double minLimitNoise = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / lowerLimitScale;
                double maxLimitNoise = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale) / upperLimitScale;
                minLimitNoise -= densityOffset;
                maxLimitNoise -= densityOffset;
                minLimitNoise += islandOffset;
                maxLimitNoise += islandOffset;
                double delta = mainNoise;
                if (oldInfdev) {
                    minLimitNoise = Mth.clamp((double)minLimitNoise, (double)-10.0, (double)10.0);
                    maxLimitNoise = Mth.clamp((double)maxLimitNoise, (double)-10.0, (double)10.0);
                    delta = (delta + 1.0) / 2.0;
                }
                density = minLimitNoise + (maxLimitNoise - minLimitNoise) * delta;
            }
            double heightmapDensity = density;
            density = this.sampleNoisePostProcessor(density, noiseX, noiseY, noiseZ);
            density = this.applySlides(density, y);
            heightmapDensity = this.applySlides(heightmapDensity, y);
            primaryBuffer[y] = density;
            heightmapBuffer[y] = heightmapDensity;
        }
    }

    @Override
    protected PerlinOctaveNoise getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    @Override
    protected Random createRandom(long seed) {
        if (this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_3D_SETTINGS).pocketEditionRng()) {
            return new MTRandom(seed);
        }
        return super.createRandom(seed);
    }

    @Override
    protected Random createSurfaceRandom(int chunkX, int chunkZ) {
        if (this.noise3DSettings.pocketEditionRng()) {
            long seed = (long)chunkX * 341872712L + (long)chunkZ * 132899541L;
            return new MTRandom(seed);
        }
        return super.createSurfaceRandom(chunkX, chunkZ);
    }

    @Override
    protected int getHeightSampleRadius() {
        return this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_3D_SETTINGS).pocketEditionRng() ? 1 : 2;
    }

    @Override
    protected float calculateBiomeHeightWeight(int x, int z) {
        if (this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_3D_SETTINGS).pocketEditionRng()) {
            x = -1;
        }
        return super.calculateBiomeHeightWeight(x, z);
    }

    private double getOffset(int noiseY, double heightStretch, double depth, double scale) {
        if (this.noiseScale.useFixedOffset()) {
            return this.noiseScale.fixedOffset();
        }
        double offset = ((double)noiseY - depth) * heightStretch / scale;
        if (offset < 0.0) {
            offset *= (double)this.noiseScale.densityUnderdamp();
        }
        return offset;
    }
}

